/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.ui.internal.exported.widget.IFacetSetSelectionWidget;
import org.eclipse.emf.facet.efacet.ui.internal.exported.widget.IFacetSetSelectionWidgetFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Test;

public class FacetSetsSelectionWidgetTests {
    private FacetSetSelectionWidgetInShell openWidget(final boolean multiSelection, final boolean allowEmptySelection) {
        final FacetSetSelectionWidgetInShell[] result = new FacetSetSelectionWidgetInShell[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell = new Shell();
                shell.setSize(800, 600);
                shell.setLayout((Layout)new GridLayout());
                IFacetSetSelectionWidget widget = IFacetSetSelectionWidgetFactory.DEFAULT.createFacetSetSelectionWidget(multiSelection ? Integer.MAX_VALUE : 1, allowEmptySelection, (Composite)shell, null);
                shell.open();
                result[0] = new FacetSetSelectionWidgetInShell(shell, widget);
            }
        });
        return result[0];
    }

    @Test
    public void testSelectSingleFacetSet() throws Exception {
        FacetSetSelectionWidgetInShell widgetInShell = this.openWidget(false, true);
        IFacetSetSelectionWidget widget = widgetInShell.getWidget();
        widget.setAvailableFacetSets(IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl()).getRegisteredFacetSets());
        widgetInShell.close();
    }

    private class FacetSetSelectionWidgetInShell {
        private final Shell shell;
        private final IFacetSetSelectionWidget widget;

        public FacetSetSelectionWidgetInShell(Shell shell, IFacetSetSelectionWidget widget) {
            this.shell = shell;
            this.widget = widget;
        }

        public Shell getShell() {
            return this.shell;
        }

        public void close() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    FacetSetSelectionWidgetInShell.this.getShell().close();
                }
            });
        }

        public IFacetSetSelectionWidget getWidget() {
            return this.widget;
        }
    }
}

