/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.editors.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.infra.browser.BrowserPlugin;
import org.eclipse.emf.facet.infra.browser.Messages;
import org.eclipse.emf.facet.infra.browser.editors.BrowserConfiguration;
import org.eclipse.emf.facet.infra.browser.editors.table.TableEditorInput;
import org.eclipse.emf.facet.infra.browser.editors.table.TableElement;
import org.eclipse.emf.facet.infra.browser.editors.table.TableElementWithContext;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditorFactory {
    private static TableEditorFactory instance;

    protected TableEditorFactory() {
    }

    public static TableEditorFactory getInstance() {
        if (instance == null) {
            instance = new TableEditorFactory();
        }
        return instance;
    }

    public void openOn(BrowserConfiguration browserConfiguration, List<? extends Object> elements, String description) {
        ArrayList<TableElement> tableElements = new ArrayList<TableElement>();
        for (Object object : elements) {
            tableElements.add(new TableElement(object));
        }
        TableEditorInput tableEditorInput = new TableEditorInput(browserConfiguration, tableElements, description);
        this.openOn(tableEditorInput);
    }

    protected void openOn(TableEditorInput input) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)this.getEditorID(), (boolean)true);
        }
        catch (PartInitException e) {
            BrowserPlugin.logException(e);
        }
    }

    protected String getEditorID() {
        return "org.eclipse.emf.facet.infra.browser.table.editorID";
    }

    public void openOn(List<ModelQueryResult> result) {
        ArrayList<TableElement> tableElements = new ArrayList<TableElement>();
        for (ModelQueryResult modelQueryResult : result) {
            Object value = modelQueryResult.getValue();
            TableEditorFactory.flattenToList(value, tableElements, modelQueryResult.getSource());
        }
        String description = NLS.bind((String)Messages.TableEditor_Description_modelQueryResults, (Object)new Integer(tableElements.size()));
        BrowserConfiguration browserConfiguration = new BrowserConfiguration();
        ComposedAdapterFactory.Descriptor.Registry registry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
        ComposedAdapterFactory adapterFactoryWithRegistry = new ComposedAdapterFactory(registry);
        browserConfiguration.getAppearanceConfiguration().setAdapterFactory(adapterFactoryWithRegistry);
        TableEditorInput input = new TableEditorInput(browserConfiguration, tableElements, description);
        this.openOn(input);
    }

    private static void flattenToList(Object value, List<TableElement> tableElements, EObject context) {
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            for (Object element : iterable) {
                TableEditorFactory.flattenToList(element, tableElements, context);
            }
        } else {
            tableElements.add(new TableElementWithContext(value, context));
        }
    }
}

