/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.sort.SortDirectionEnum;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryRow;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElementWithContext;
import org.eclipse.emf.facet.widgets.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.nattable.internal.TableLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
class BodyDataProvider
implements IDataProvider {
    private final int columnCount;
    private final List<Row> originalElements;
    private List<Row> elements;
    private final List<Column> columns;
    private final Shell shell;
    private final EditingDomain editingDomain;
    private final TableLabelProvider tableLabelProvider;
    private final FacetContext facetContext;

    public BodyDataProvider(EList<Row> rowsList, int columnCount, List<Column> columns, Shell shell, EditingDomain editingDomain, TableLabelProvider labelProvider, FacetContext facetContext) {
        this.columns = columns;
        this.shell = shell;
        this.editingDomain = editingDomain;
        this.tableLabelProvider = labelProvider;
        this.originalElements = rowsList;
        this.elements = new ArrayList<Row>((Collection<Row>)rowsList);
        this.columnCount = columnCount;
        this.facetContext = facetContext;
    }

    public Row getRow(int row) {
        return this.elements.get(row);
    }

    public int getRowCount() {
        return this.elements.size();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        Column column = this.columns.get(columnIndex);
        Row row = this.elements.get(rowIndex);
        if (row instanceof QueryRow) {
            QueryRow tableElementWithContext = (QueryRow)row;
            return new GridElementWithContext(row.getElement(), tableElementWithContext.getQueryResult().getSource(), column);
        }
        return new GridElement(row.getElement(), column);
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        Column column = this.columns.get(columnIndex);
        EObject element = this.elements.get(rowIndex).getElement();
        if (element instanceof EObject) {
            EObject eObject = element;
            if (!(column instanceof FeatureColumn)) {
                throw new RuntimeException("Cannot edit in column of type " + column.eClass().getName());
            }
            EStructuralFeature feature = ((FeatureColumn)column).getFeature();
            if (!feature.isChangeable()) {
                throw new RuntimeException("Feature is not changeable: " + feature.getName());
            }
            Object prevValue = null;
            if (feature instanceof FacetStructuralFeature) {
                try {
                    prevValue = this.facetContext.get(eObject, feature);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                prevValue = eObject.eGet(feature);
            }
            if (prevValue == newValue) {
                return;
            }
            if (newValue == null && !feature.isUnsettable()) {
                MessageDialog.openWarning((Shell)this.shell, (String)Messages.BodyDataProvider_cannotUnset, (String)NLS.bind((String)Messages.BodyDataProvider_featureIsNotUnsettable, (Object)feature.getName()));
                return;
            }
            if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                Object object = eObject.eGet(feature);
                boolean empty = object == null || object instanceof List && ((List)object).isEmpty();
                String message = empty ? Messages.BodyDataProvider_valueWillBeMoved : Messages.BodyDataProvider_valueWillBeMovedAndPreviousLost;
                String fullMessage = String.valueOf(Messages.BodyDataProvider_featureIsComposite) + message;
                if (!MessageDialog.openConfirm((Shell)this.shell, (String)Messages.BodyDataProvider_moveElement, (String)fullMessage)) {
                    return;
                }
            }
            if (feature instanceof FacetStructuralFeature) {
                try {
                    this.facetContext.set(eObject, (FacetStructuralFeature)feature, newValue, this.editingDomain);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(this.editingDomain);
                Command setCommand = commandFactory.createSetCommand(this.editingDomain, (Object)eObject, (Object)feature, newValue);
                this.editingDomain.getCommandStack().execute(setCommand);
            }
        }
    }

    public void sort(final int columnIndex, final SortDirectionEnum sortDirection) {
        if (sortDirection == SortDirectionEnum.NONE) {
            this.elements = new ArrayList<Row>(this.originalElements);
        } else {
            Collections.sort(this.elements, new Comparator<Row>(){

                @Override
                public int compare(Row t1, Row t2) {
                    Column columnDescription = (Column)BodyDataProvider.this.columns.get(columnIndex);
                    String label1 = BodyDataProvider.this.tableLabelProvider.getColumnText(new GridElement(t1.getElement(), columnDescription), columnIndex);
                    String label2 = BodyDataProvider.this.tableLabelProvider.getColumnText(new GridElement(t2.getElement(), columnDescription), columnIndex);
                    if (sortDirection == SortDirectionEnum.ASC) {
                        return label1.compareToIgnoreCase(label2);
                    }
                    return label2.compareToIgnoreCase(label1);
                }
            });
        }
    }
}

