/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.swtbot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.NatTableEditorFactory;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class Bug343811Test {
    private static final String RESOURCES = "/resources/v0_1/Bug343811/";
    private static final int TIMEOUT = 30000;
    private static final int PREF_TIMEOUT = 5000;
    private static final int PREF_TYPE_INTERVAL = 10;
    private static final String PROJECT_NAME = Bug343811Test.class.getSimpleName();
    private static final String ECORE_FILE_NAME = "_Bug343811_EcoreModel.ecore";
    private static final String TABLE_CONFIGURATION_FILE_PATH = "/resources/v0_1/Bug343811/_Bug343811_EcoreTableConfiguration.tableconfiguration";

    @BeforeClass
    public static void beforeClass() throws CoreException {
        SWTBotPreferences.TIMEOUT = 5000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
    }

    @Before
    public void beforeTests() throws CoreException, IOException {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/Bug343811/_Bug343811_EcoreModel.ecore", (IProject)testProject, (String)"/_Bug343811_EcoreModel.ecore", (Bundle)bundle);
    }

    private void openTableFile(String fileName) {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.captureScreenShot((String)"1");
        bot.menu("Window").menu("Show View").menu("Project Explorer").click();
        SWTBotUtils.captureScreenShot((String)"2");
        SWTBotView view = bot.viewByTitle("Project Explorer");
        view.setFocus();
        List controls = new ChildrenControlFinder((Widget)bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Tree.class));
        assert (controls.size() == 1);
        SWTBotTree tree = new SWTBotTree((Tree)controls.get(0));
        final SWTBotTreeItem item = tree.expandNode(new String[]{PROJECT_NAME}).getNode(fileName).select();
        try {
            ((SWTBotMenu)UIThreadRunnable.syncExec((Result)new Result<SWTBotMenu>(){

                public SWTBotMenu run() {
                    try {
                        return item.contextMenu("Open With").menu("Other...");
                    }
                    catch (WidgetNotFoundException widgetNotFoundException) {
                        return null;
                    }
                }
            })).click();
            SWTBotTable table = bot.table();
            table.select(new String[]{"Sample Ecore Model Editor"});
            bot.button("OK").click();
        }
        catch (NullPointerException nullPointerException) {
            item.doubleClick();
        }
    }

    @Test(timeout=30000L)
    @Ignore
    public void testBug343811() {
        this.openTableFile(ECORE_FILE_NAME);
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotEditor swtBotEditor = bot.editorByTitle(ECORE_FILE_NAME);
        swtBotEditor.setFocus();
        Assert.assertTrue((boolean)swtBotEditor.isActive());
        swtBotEditor.bot().tree().expandNode(new String[]{"platform:/resource/" + PROJECT_NAME + "/" + ECORE_FILE_NAME}).select("MyPackage").click();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                StructuredSelection structuredSelection;
                Object fistElement;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                ISelection selection = window.getSelectionService().getSelection();
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IEditingDomainProvider editingDomainProvider = null;
                EditingDomain editingDomain = null;
                if (editor != null && editor instanceof IEditingDomainProvider) {
                    editingDomainProvider = (IEditingDomainProvider)editor;
                    editingDomain = editingDomainProvider.getEditingDomain();
                }
                if (selection instanceof StructuredSelection && (fistElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof EPackage) {
                    EPackage ePackage = (EPackage)fistElement;
                    try {
                        ResourceSet resourceSet = ePackage.eResource().getResourceSet();
                        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + Bug343811Test.TABLE_CONFIGURATION_FILE_PATH), (boolean)false);
                        Resource resource = resourceSet.getResource(uri, true);
                        TableConfiguration tableConfiguration = (TableConfiguration)resource.getContents().get(0);
                        ArrayList list = new ArrayList();
                        list.addAll(ePackage.getEClassifiers());
                        NatTableEditorFactory.getInstance().openOn(list, editingDomain, "Example of customized table editor", tableConfiguration, (EObject)ePackage, null);
                    }
                    catch (UnsatisfiedConfigurationConstraint e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        SWTBotEditor tableEditor = bot.editorByTitle("Model Table");
        tableEditor.setFocus();
        SWTBotToolbarButton createNewElementToobarButton = SWTBotUtils.getToolbarButton((String)"Create new element", (int)0, (SWTWorkbenchBot)bot);
        createNewElementToobarButton.click();
        createNewElementToobarButton.click();
        bot.menu("File").menu("Save").click();
        bot.tree().select(new int[]{0});
        bot.button("OK").click();
        bot.closeAllEditors();
        this.openTableFile(ECORE_FILE_NAME);
        SWTBotEditor swtBotEditor2 = bot.editorByTitle(ECORE_FILE_NAME);
        swtBotEditor2.setFocus();
        SWTBotTreeItem[] items = swtBotEditor2.bot().tree().expandNode(new String[]{"platform:/resource/" + PROJECT_NAME + '/' + ECORE_FILE_NAME}).expandNode(new String[]{"MyPackage"}).getItems();
        Assert.assertEquals((long)5L, (long)items.length);
    }
}

