/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.uithread;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class NatTableHandlersTests {
    private static final String RESOURCES = "/resources/v0_2/";
    private static final int TIMEOUT = 30000;
    private static final String RESOURCES_TEST = "tableTestNatTableAPITest.table";
    private static final String RESOURCES_ECORE_MODEL = "ecoreModel.ecore";
    private static final String PROJECT_NAME = "NatTableAPITestsProject";
    private ITableWidget natTableWidget;
    private IProject project;

    @Before
    public void initResource() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            project2.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        this.project = workspace.getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/tableTestNatTableAPITest.table", (IProject)this.project, (String)"/tableTestNatTableAPITest.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/ecoreModel.ecore", (IProject)this.project, (String)"/ecoreModel.ecore", (Bundle)bundle);
        IFile tableFile = this.project.getFile(RESOURCES_TEST);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)tableFile);
        ITableWidgetProvider natTableWidgetPart = (ITableWidgetProvider)editor.getAdapter(ITableWidgetProvider.class);
        Assert.assertNotNull((Object)natTableWidgetPart);
        this.natTableWidget = natTableWidgetPart.getTableWidget();
    }

    @Test(timeout=30000L)
    public void deleteHandlerTest() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            Assert.assertNotNull((Object)this.natTableWidget);
            EObject eObject = (EObject)TableWidgetUtils.getElements((Table)this.natTableWidget.getTable()).get(0);
            this.natTableWidget.selectDefaultLabelCell(eObject);
            if (this.natTableWidget.getSelection() instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)this.natTableWidget.getSelection();
                Assert.assertEquals((Object)selection.getFirstElement(), (Object)eObject);
            }
            int oldRowSize = this.natTableWidget.getTable().getRows().size();
            IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
            handlerService.executeCommand("org.eclipse.ui.edit.delete", null);
            Assert.assertEquals((int)(oldRowSize - 1), (int)this.natTableWidget.getTable().getRows().size());
            Assert.assertTrue((!TableWidgetUtils.getElements((Table)this.natTableWidget.getTable()).contains(eObject) ? 1 : 0) != 0);
        }
    }

    @Test(timeout=30000L)
    public void selectionTest() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            Assert.assertNotNull((Object)this.natTableWidget);
            IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
            handlerService.executeCommand("org.eclipse.ui.edit.selectAll", null);
            if (this.natTableWidget.getSelection() instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)this.natTableWidget.getSelection();
                int numberOfElementInTheTable = TableWidgetUtils.getElements((Table)this.natTableWidget.getTable()).size();
                Assert.assertEquals((int)numberOfElementInTheTable, (int)selection.size());
            }
        }
    }

    @After
    public void saveResource() {
        Assert.assertNotNull((Object)this.natTableWidget);
        this.natTableWidget.save();
    }
}

