/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.FacetCustomization;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizationUtils {
    private CustomizationUtils() {
    }

    public static Set<FacetSet> findFacetsCustomizedBy(List<Customization> customizations) {
        HashSet<FacetSet> referencedFS = new HashSet<FacetSet>();
        for (Customization customization : customizations) {
            for (EClassifier eClassifier : customization.getEClassifiers()) {
                if (!(eClassifier instanceof FacetCustomization)) continue;
                FacetCustomization facetCustom = (FacetCustomization)eClassifier;
                for (Facet extFacet : facetCustom.getExtendedFacets()) {
                    referencedFS.add((FacetSet)extFacet.getEPackage());
                }
            }
        }
        return referencedFS;
    }

    public static Customization findCustomizationExtendingEPackage(List<Customization> customizations, EPackage ePackage) {
        if (ePackage == null) {
            throw new IllegalArgumentException("ePackage must not be null");
        }
        Customization result = null;
        for (Customization customization : customizations) {
            if (customization == null || !ePackage.equals(FacetUtils.getExtendedEPackage((FacetSet)customization))) continue;
            result = customization;
            break;
        }
        return result;
    }

    public static Facet findFacetByExtendedMetaclass(Collection<Facet> facets, EClass extendedMetaClass) {
        Facet result = null;
        for (Facet facet : facets) {
            Facet candidate = facet;
            if (candidate.getExtendedMetaclass() != extendedMetaClass) continue;
            result = candidate;
            break;
        }
        return result;
    }
}

