/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.exported;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.EObjectQueryRow;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.NavigationTable;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.CreateTableUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.InternalTableUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableWidgetUtils {
    private TableWidgetUtils() {
    }

    public static NavigationTable createQueryTableInstance(List<ETypedElementResult> results, TableConfiguration tableConfiguration, EObject context, Object parameter) {
        NavigationTable queryTableInstance = TableFactory.eINSTANCE.createNavigationTable();
        queryTableInstance.getQueryResults().addAll(results);
        queryTableInstance.setTableConfiguration(tableConfiguration);
        queryTableInstance.setContext(context);
        queryTableInstance.setParameter(parameter);
        for (ETypedElementResult result : results) {
            Object resultValue = FacetUtils.getResultValue((ETypedElementResult)result);
            if (resultValue instanceof Collection) {
                Collection collection = (Collection)resultValue;
                for (Object object : collection) {
                    TableWidgetUtils.createQueryRow(queryTableInstance, result, object);
                }
                continue;
            }
            TableWidgetUtils.createQueryRow(queryTableInstance, result, resultValue);
        }
        CreateTableUtils.createColumns((Table)queryTableInstance);
        return queryTableInstance;
    }

    private static void createQueryRow(NavigationTable queryTableInstance, ETypedElementResult result, Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (!TableWidgetUtils.getElements((Table)queryTableInstance).contains(eObject)) {
                EObjectQueryRow row = TableFactory.eINSTANCE.createEObjectQueryRow();
                row.setElement(eObject);
                row.setQueryResult(result);
                queryTableInstance.getRows().add((Object)row);
            }
        } else {
            PrimitiveTypeQueryRow row = TableFactory.eINSTANCE.createPrimitiveTypeQueryRow();
            row.setElement((EObject)result);
            row.setQueryResult(result);
            row.setValue(object);
            queryTableInstance.getRows().add((Object)row);
        }
    }

    public static List<EObject> getElements(Table tableInstance) {
        return InternalTableUtils.getElements(tableInstance);
    }

    public static Object getValueOf(IGridElement gridElement, IFacetManager context) throws FacetManagerException {
        EObject element;
        Object value = null;
        if (gridElement.getColumn() instanceof FeatureColumn && (element = gridElement.getRow().getElement()) != null) {
            FeatureColumn featureColumn = (FeatureColumn)gridElement.getColumn();
            ETypedElement eTypedElement = featureColumn.getFeature();
            if (InternalTableUtils.hasStructuralFeature(element, eTypedElement, context)) {
                value = context.getOrInvoke(element, eTypedElement, Object.class);
            } else {
                return "\ufffd";
            }
        }
        return value;
    }

    public static boolean isApplicable(IGridElement gridElement, IFacetManager context) {
        EObject element;
        boolean result = false;
        if (gridElement.getColumn() instanceof FeatureColumn && (element = gridElement.getRow().getElement()) != null) {
            FeatureColumn featureColumn = (FeatureColumn)gridElement.getColumn();
            ETypedElement eTypedElement = featureColumn.getFeature();
            try {
                if (InternalTableUtils.hasStructuralFeature(element, eTypedElement, context)) {
                    result = true;
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }
}

