/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.tests.internal;

import junit.framework.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProviderFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.junit.Test;

public class LabelProviderCacheTest {
    @Test
    public void testFontCash() {
        Font font2;
        EClass eClass = EcorePackage.eINSTANCE.getEAnnotation();
        ICustomizedLabelProvider labelProvider = LabelProviderCacheTest.createLabelProvider();
        Font font1 = labelProvider.getFont((Object)eClass);
        Assert.assertTrue((String)"The label provider must return the same instance of Font for a same eObject", (font1 == (font2 = labelProvider.getFont((Object)eClass)) ? 1 : 0) != 0);
    }

    private static ICustomizedLabelProvider createLabelProvider() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
        ICustomizationManager customizationMgr = ICustomizationManagerFactory.DEFAULT.createICustomizationManager(facetManager);
        return ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customizationMgr);
    }

    @Test
    public void testBackgoundCash() {
        Color color2;
        EClass eClass = EcorePackage.eINSTANCE.getEAnnotation();
        ICustomizedLabelProvider labelProvider = LabelProviderCacheTest.createLabelProvider();
        Color color1 = labelProvider.getBackground((Object)eClass);
        Assert.assertTrue((String)"The label provider must return the same instance of Color for a same eObject", (color1 == (color2 = labelProvider.getBackground((Object)eClass)) ? 1 : 0) != 0);
    }

    @Test
    public void testForegoundCash() {
        Color color2;
        EClass eClass = EcorePackage.eINSTANCE.getEAnnotation();
        ICustomizedLabelProvider labelProvider = LabelProviderCacheTest.createLabelProvider();
        Color color1 = labelProvider.getForeground((Object)eClass);
        Assert.assertTrue((String)"The label provider must return the same instance of Color for a same eObject", (color1 == (color2 = labelProvider.getForeground((Object)eClass)) ? 1 : 0) != 0);
    }

    @Test
    public void labelProviderDispose() {
        EcorePackage.eINSTANCE.getEAnnotation();
        ICustomizedLabelProvider labelProvider = LabelProviderCacheTest.createLabelProvider();
        labelProvider.dispose();
    }
}

