/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationsDelegatingList
implements List<Customization> {
    private final List<FacetSet> delegate;

    public CustomizationsDelegatingList(List<FacetSet> delegate) {
        this.delegate = delegate;
    }

    private List<Customization> createSubList() {
        ArrayList<Customization> customizations = new ArrayList<Customization>(this.delegate.size());
        for (FacetSet facetSet : this.delegate) {
            if (!(facetSet instanceof Customization)) continue;
            Customization customization = (Customization)facetSet;
            customizations.add(customization);
        }
        return customizations;
    }

    @Override
    public int size() {
        return this.createSubList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.createSubList().isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return element instanceof Customization && this.delegate.contains(element);
    }

    @Override
    public Iterator<Customization> iterator() {
        List<Customization> customizations = this.createSubList();
        return customizations.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.createSubList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.createSubList().toArray(a);
    }

    @Override
    public boolean add(Customization customization) {
        return this.delegate.add((FacetSet)customization);
    }

    @Override
    public boolean remove(Object element) {
        return this.delegate.remove(element);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.createSubList().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends Customization> collection) {
        return this.delegate.addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Customization> collection) {
        return this.delegate.addAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.createSubList().retainAll(collection);
    }

    @Override
    public void clear() {
        ListIterator<FacetSet> listIterator = this.delegate.listIterator();
        while (listIterator.hasNext()) {
            FacetSet facetSet = listIterator.next();
            if (!(facetSet instanceof Customization)) continue;
            listIterator.remove();
        }
    }

    @Override
    public Customization get(int index) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Customization set(int index, Customization element) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void add(int index, Customization element) {
        if (index != 0) {
            throw new UnsupportedOperationException("not implemented");
        }
        this.delegate.add(0, (FacetSet)element);
    }

    @Override
    public Customization remove(int index) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public int indexOf(Object element) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public int lastIndexOf(Object element) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public ListIterator<Customization> listIterator() {
        return this.createSubList().listIterator();
    }

    @Override
    public ListIterator<Customization> listIterator(int index) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public List<Customization> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("not implemented");
    }
}

