/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.ui.tests.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPackageRegistryTest {
    private static final int TIMEOUT = 30000;

    @BeforeClass
    public static void beforeClass() throws Exception {
        SWTBotPreferences.TIMEOUT = 5000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotUtils.startDebugDumpingIfEnabled();
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        EPackageRegistryTest.disableEMFFacetCapability();
    }

    public static void disableEMFFacetCapability() throws Exception {
        final IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = activitySupport.getActivityManager();
        final HashSet<String> newActivities = new HashSet<String>(activityManager.getEnabledActivityIds());
        newActivities.add("org.eclipse.emf.facet.capabilities.activity");
        newActivities.add("org.eclipse.emf.facet.infra.activities");
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                activitySupport.setEnabledActivityIds((Set)newActivities);
            }
        });
    }

    @Test(timeout=30000L)
    public void canOpenERegistryView() throws Exception {
        SWTBotUtils.captureScreenShot((String)"before");
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        bot.menu("Window").menu("Show View").menu("Other...").click();
        SWTBotUtils.captureScreenShot((String)"1 clicked Window - Show View - Other");
        bot.shell("Show View").activate();
        SWTBotUtils.captureScreenShot((String)"2 activated Show View");
        bot.tree().setFocus();
        bot.tree().expandNode(new String[]{"EMF Facet"}).select("EPackage Registry");
        SWTBotUtils.captureScreenShot((String)"3 activated Show View");
        bot.button("OK").click();
        SWTBotUtils.captureScreenShot((String)"4 clicked OK");
        SWTBotView view = bot.viewByTitle("EPackage Registry");
        Assert.assertNotNull((Object)view);
        view.setFocus();
    }

    @AfterClass
    public static void afterClass() {
        new SWTWorkbenchBot().closeAllShells();
    }
}

