/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.core.tests.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.utils.FileUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.common.core.tests.internal.Activator;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class EcoreCatalogTest {
    private static final String FILE_EXT = ".ecore";

    @Test
    public void bug309657() throws Exception {
        IProject project = ProjectUtils.createTestProject((String)"bug309657", (Bundle)Activator.getDefault().getBundle(), (String)".");
        FileUtils.copyFileFromBundle((String)"resources/bug309657.ecore", (IProject)project, (String)"bug309657.ecore", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        IFolder folder = project.getFolder("f1");
        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IFile sourceFile = project.getFile("bug309657.ecore");
        IPath sourcePath = sourceFile.getFullPath();
        Path targetPath = new Path(folder.getFullPath() + "/" + "bug309657" + FILE_EXT);
        sourceFile.move((IPath)targetPath, true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)targetPath);
        IMarker[] markers = targetFile.findMarkers(AbstractEmfFacetCatalog.PROBLEM_MARKER, true, 2);
        Assert.assertEquals((long)0L, (long)markers.length);
        targetFile.move(sourcePath, true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        markers = sourceFile.findMarkers(AbstractEmfFacetCatalog.PROBLEM_MARKER, true, 2);
        Assert.assertEquals((long)0L, (long)markers.length);
    }

    @Test
    public void bug309990() throws Exception {
        String nsURI = "http://www.eclipse.org/MoDisco/bug309990";
        Assert.assertNull((Object)EPackage.Registry.INSTANCE.get((Object)nsURI));
        IProject project = ProjectUtils.createTestProject((String)"bug309990", (Bundle)Activator.getDefault().getBundle(), (String)".");
        FileUtils.copyFileFromBundle((String)"resources/bug309990.ecore", (IProject)project, (String)"bug309990.ecore", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        Assert.assertNotNull((Object)EPackage.Registry.INSTANCE.get((Object)nsURI));
        FileUtils.copyFileFromBundle((String)"resources/bug309990_bis.ecore", (IProject)project, (String)"bug309990.ecore", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        Assert.assertNotNull((Object)EPackage.Registry.INSTANCE.get((Object)(String.valueOf(nsURI) + "_bis")));
        Assert.assertNull((Object)EPackage.Registry.INSTANCE.get((Object)nsURI));
        project.getFile("bug309990.ecore").delete(true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        Assert.assertNull((Object)EPackage.Registry.INSTANCE.get((Object)(String.valueOf(nsURI) + "_bis")));
    }
}

