/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *     Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation 
 *******************************************************************************/
package org.eclipse.emf.facet.infra.browser.actions;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ui.actions.AbstractLoadCustomizationsAction;
import org.eclipse.emf.facet.infra.browser.editors.EcoreBrowser;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.swt.widgets.Shell;

public class LoadCustomizationsAction extends AbstractLoadCustomizationsAction {

	private final IBrowserActionBarContributor browserActionBarContributor;

	public LoadCustomizationsAction(final IBrowserActionBarContributor browserActionBarContributor) {
		super();
		this.browserActionBarContributor = browserActionBarContributor;
	}

	@Override
	protected void loadCustomizations(final List<MetamodelView> selectedCustomizations) {
		this.browserActionBarContributor.getBrowser().loadCustomizations(selectedCustomizations);

	}

	@Override
	protected Shell getShell() {
		return this.browserActionBarContributor.getBrowser().getSite().getShell();
	}

	@Override
	protected Collection<EPackage> getReferencedEPackages() {
		return this.browserActionBarContributor.getBrowser().getReferencedEPackages();
	}

	@Override
	protected void loadFacet(final Facet referencedFacet) {
		this.browserActionBarContributor.getBrowser().getBrowserConfiguration()
				.getAppearanceConfiguration().loadFacet(referencedFacet);
	}

	@Override
	protected void facetsLoaded() {
		facetsLoaded(null);
	}

	@Override
	protected void facetsLoaded(final Set<Facet> referencedFacets) {
		EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
		// for modified facets
		browser.getBrowserConfiguration().getInstancesForMetaclasses().buildDerivationTree();
		browser.getBrowserConfiguration().getAppearanceConfiguration().touch();
		browser.refreshDelayed(true);
	}

	@Override
	protected List<MetamodelView> getRegisteredCustomizations() {
		return this.browserActionBarContributor.getBrowser().getBrowserConfiguration()
				.getAppearanceConfiguration().getCustomizationEngine()
				.getRegisteredCustomizations();
	}
}
