/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire Dupe (Mia-Software) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 340940 - To be able to view facet attributes and facet references in a table
 *    Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 342451 - To be able to edit derived facet attributes and derived facet references in a table
 *    Nicolas Guyomar (Mia-Software) - Bug 345554 - SWTBot regression on build 303
 *    Grgoire Dup (Mia-Software) - Bug 365808 - [Unit Test Failure][0.2/4.2][0.2/3.8] org.eclipse.emf.facet.widgets.nattable.tests.NatTableAPITests
 *    Gregoire Dupe (Mia-Software) - Bug 368030 - [Unit Test Failure] org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.swtbot.NatTableUITests.testAddQueryColumn
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;

import net.sourceforge.nattable.coordinate.PositionCoordinate;

import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.exported.IMustRemoveNonConformingElementsDialog;
import org.eclipse.swt.graphics.Point;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public interface INatTableWidgetInternal extends INatTableWidget, INatTableWidget2 {
	public IColumnsToHideDialog openColumnsToHideDialog();
	public TableLabelProvider getTableLabelProvider();
	
	/**
	 * 
	 * @param table
	 *            the table
	 * @param setToTheTop
	 *            this attribute is used to know if we need to simulate the
	 *            moving of the local custom to the top of the custom stack
	 * @return the visible columns using the local customization file
	 */
	public List<Column> getVisibleColumnsUsingTheLocalCustomizations(final TableInstance2 table,
			final boolean setToTheTop);

	/**
	 * 
	 * @return the visible columns using the layer
	 */
	public List<Column> getVisibleColumnsUsingTheLayer();

	/**
	 * 
	 * @param customizationsToLoad
	 * set the list of customization to the tableInstance and register and load them in the customization engine
	 */
	public void loadCustomizations(final List<MetamodelView> customizationsToLoad);
	
	/**
 	 * return the Display relative position of a cell.
	 * @param columnPosition  the cell's column
	 * @param rowPosition the cell's row
	 * @return a {@link Point} corresponding to the cell position relatively to the Display
	 */
	public Point getCellPositionRelativeToDisplay(final int columnPosition, final int rowPosition);
	
	/**
	 * Wait for the resfresh job to finish
	 */
	public int waitForResfreshJob();
	public int waitForResfreshJob(final int lastState);
	
	public FacetContext getFacetContext();
	public boolean usesTmpResource();
	public List<PositionCoordinate> getSelectedCellsPositions();
	
	/**
	 * This method has to be used to set a canBePresentedInTheTable query. A
	 * canBePresentedInTheTable query presented query is used to now if a model
	 * element can be presented in the table. For instance, this query is used
	 * to know if the table must accept a model element form a drag and drop.
	 * 
	 * If model elements already presented in the table are not conform to the
	 * new canBePresentedInTheTable query, then the user will have to choose if
	 * he wants to remove them from the table.
	 * 
	 * @param query
	 *            the new "canBePresentedInTheTable" query. This query must
	 *            return a boolean and EObject as scope.
	 */
	IMustRemoveNonConformingElementsDialog setCanBePresentedInTheTable(ModelQuery query);
	
}
