/*******************************************************************************
 * Copyright (c) 2010, 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331203 - table model editor - initial API and implementation
 *    Nicolas Bros (Mia-Software) - Bug 332437 - NatTable : pluggable cell editors
 *    Nicolas Guyomar (Mia-Software) - Bug 331442 - To be able to add and remove lines (model elements) from the table
 *    Nicolas Bros (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table
 *    Nicolas Guyomar (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table
 *    Nicolas Bros (Mia-Software) - Bug 332438 - NatTable : table type
 *    Nicolas Bros (Mia-Software) - Bug 332440 - NatTable : force cell editors
 *    Nicolas Bros (Mia-Software) - Bug 331675 - NatTable : copy cells as text 
 *    Nicolas Bros (Mia-Software) - Bug 331900 - customizable NatTable
 *    Nicolas Bros (Mia-Software) - Bug 332010 - view Facet customizations on NatTable
 *    Nicolas Bros (Mia-Software) - Bug 332215 - customizable NatTable column headers
 *    Nicolas Guyomar (Mia-Software) - Bug 332215 - customizable NatTable column headers
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Nicolas Guyomar (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Nicolas Guyomar (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *    Nicolas Guyomar (Mia-Software) - Bug 333414 - The user must be able to save the column order
 *    Nicolas Guyomar (Mia-Software) - Bug 335154 - Sort Column By Type : Cannot modify resource set without a write transaction
 *    Nicolas Guyomar (Mia-Software) - Bug 335155 - Hide Empty Column : Cannot modify resource set without a write transaction
 *    Nicolas Guyomar (Mia-Software) - Bug 335156 - Only Show Common column : Cannot modify resource set without a write transaction
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 337322 - [TableConfiguration] Customization declared in the file tableconfiguration is not loaded
 *    Nicolas Guyomar (Mia-Software) - Bug 338536 - Problem with the refresh of the table : the scrollbar returns to this initial position
 *    Nicolas Bros (Mia-Software) - Bug 338536 - Problem with the refresh of the table : the scrollbar returns to this initial position
 *    Nicolas Guyomar (Mia-Software) - Bug 337454 - We can't delete a query Column
 *    Nicolas Guyomar (Mia-Software) - Bug 337395 - Unused columns should be destroyed
 *    Nicolas Guyomar (Mia-Software) - Bug 339554 - org.eclipse.emf.facet.widgets.celleditors API cleaning
 *    Nicolas Guyomar (Mia-Software) - Bug 339922 - INatTableWidget method isCellSelected should use the plural
 *    Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *    Vincent Lorenzo (CEA-LIST) - Bug 337326 - Show/Hide Column : Sort the columns by name 
 *    Nicolas Guyomar (Mia-Software) - Bug 340940 - To be able to view facet attributes and facet references in a table
 *    Vincent Lorenzo (CEA-LIST) - Bug 337408 - Add an action to sort columns by name 
 *    Nicolas Guyomar (Mia-Software) - Bug 336482 - KeyBinding to edit element in Table : F2 
 *    Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Gregoire Dupe (Mia-Software) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 342451 - To be able to edit derived facet attributes and derived facet references in a table
 *    Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 343411 - [Table] Create new elements does not support IJavaModelQuery anymore
 *    Gregoire Dupe (Mia-Software) - Bug 343811 - EMF Facet Regression : Created elements in a table are not serialized
 *    Vincent Lorenzo (CEA-LIST) - Bug 344125 - The API should provide a method selectRows(List<EObject> elementsToSelect)
 *    Nicolas Guyomar (Mia-Software) - Bug 344274 - SWT BOT fail on Hudson
 *    Nicolas Guyomar (Mia-Software) - Bug 344475 - To be able to select a cell by EStructuralFeature in the table
 *    Nicolas Guyomar (Mia-Software) - Bug 342028 - Field can be edited even if they are marked as N/A
 *    Nicolas Guyomar (Mia-Software) - Bug 344413 - Facet Columns are never created when we begin with an empty table
 *    Gregoire Dupe (Mia-Software) - Bug 343859 - The local customizations are not applied when we reopen a table
 *    Nicolas Guyomar (Mia-Software) - Bug 344670 - Problems with the columns creation : very slow + scrollbar blinked
 *    Vincent Lorenzo (CEA LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 344925 - Undo/Redo after the action Show Columns
 *    Gregoire Dupe (Mia-Software) - Bug 344925 - Undo/Redo after the action Show Columns - Regression fix
 *    Nicolas Guyomar (Mia-Software) - Bug 345665 - Columns are duplicated when you drop many elements in the same time
 *    Nicolas Guyomar (Mia-Software) - Bug 346465 - [EMF Facet Table] Remove line does not remove obsolete column
 *    Gregoire Dupe (Mia-Software) - Bug 345730 - Deleting an element in the model breaks the table
 *    Gregoire Dupe (Mia-Software) - Bug 354224 - mutually exclusive Facets
 *    Grgoire Dup (Mia-Software) - Bug 356795 - [Unit Test Failure][0.2/4.2][0.2/3.8] org.eclipse.emf.facet.widgets.nattable.tests.Bug344413Test.testBug344413
 *    Laurent Pichierri (Soft-Maint) - Bug 371204 - Compatibility with Helios
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import net.sourceforge.nattable.coordinate.PositionCoordinate;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.browser.custom.CustomView;
import org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature;
import org.eclipse.emf.facet.infra.browser.custom.CustomizableFeatures;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.StaticFeatureValue;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.emf.UicustomFactory;
import org.eclipse.emf.facet.infra.browser.custom.emf.UicustomPackage;
import org.eclipse.emf.facet.infra.browser.custom.util.UicustomUtil;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.MultiModelQueryException;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.UnresolvedProxyException;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public final class TableInstanceCommandFactory {
	
	protected static final String DEBUG_OPTION = "org.eclipse.emf.facet.widgets.nattable/debug/TableInstanceCommandFactory"; //$NON-NLS-1$
	protected static final boolean DEBUG = Activator.getDefault().isDebugging()
			&& Boolean.parseBoolean(Platform.getDebugOption(TableInstanceCommandFactory.DEBUG_OPTION));


	public static Command createLoadCustomizationsCommand(
			final List<MetamodelView> customizationsToLoad, final NatTableWidget natTableWidget) {
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		List<MetamodelView> localCustomizations = natTableWidget.getLocalCustomizations();
		if (!localCustomizations.isEmpty()
				&& !customizationsToLoad.containsAll(localCustomizations)) {
			// the locals custom must always be set here
			customizationsToLoad.addAll(0, localCustomizations);
		}
		if (!customizationsToLoad.isEmpty()) {
			return commandFactory.createSetCommand(natTableWidget.getEditingDomain(),
					natTableWidget.getTableInstance(),
					TableinstancePackage.eINSTANCE.getTableInstance_Customizations(),
					customizationsToLoad);
		}
		return null;
	}

	public static Command createDeleteSelectedColumnCommand(final NatTableWidget natTableWidget) {
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		CompoundCommand compoundCommand = new CompoundCommand();

		for (Column column : natTableWidget.getSelectedColumns()) {
			Command removeRowCommand = commandFactory.createRemoveCommand(
					natTableWidget.getEditingDomain(), natTableWidget.getTableInstance(),
					TableinstancePackage.eINSTANCE.getTableInstance_Columns(), column);
			compoundCommand.append(removeRowCommand);
		}
		return compoundCommand;
	}

	/**
	 * 
	 * @param natTableWidget
	 * @return
	 * @throws CoreException can be caused by query error in the facet framework
	 */
	public static Command createDeleteSelectedElementCommand(final NatTableWidget natTableWidget,
			final ICommandFactory commandFactory) throws CoreException {
		List<Integer> toBeDeleted = null;
		CompoundCommand compoundCommand = new CompoundCommand();
		toBeDeleted = new ArrayList<Integer>();
		PositionCoordinate[] selectedCells = natTableWidget.getBodyLayer().getSelectionLayer()
				.getSelectedCells();

		for (PositionCoordinate positionCoordinate : selectedCells) {
			if (!toBeDeleted.contains(positionCoordinate.rowPosition)) {
				toBeDeleted.add(positionCoordinate.rowPosition);
			}
		}
		TableInstance tableInstance = natTableWidget.getTableInstance();
		for (int i = 0; i < tableInstance.getRows().size(); i++) {
			if (toBeDeleted.contains(i)) {
				Command deleteEltCommand = commandFactory.createDeleteCommand(
						natTableWidget.getEditingDomain(), tableInstance.getRows().get(i)
								.getElement());
				compoundCommand.append(deleteEltCommand);
			}
		}
		return compoundCommand;
	}

	/**
	 * 
	 * @param natTableWidget
	 * @return
	 * @throws CoreException can be caused by query error in the facet framework
	 */
	public static Command createRemoveLineCommand(final NatTableWidget natTableWidget) throws CoreException {
		CompoundCommand compoundCommand = new CompoundCommand();
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		TableInstance tableInstance = natTableWidget.getTableInstance();
		List<Integer> toBeRemoved = new ArrayList<Integer>();
		PositionCoordinate[] selectedCells = natTableWidget.getBodyLayer().getSelectionLayer()
				.getSelectedCells();

		for (PositionCoordinate positionCoordinate : selectedCells) {
			if (!toBeRemoved.contains(positionCoordinate.rowPosition)) {
				toBeRemoved.add(positionCoordinate.rowPosition);
			}
		}
		for (int i = 0; i < tableInstance.getElements().size(); i++) {
			if (toBeRemoved.contains(i)) {
				Command removeRowCommand = commandFactory.createRemoveCommand(natTableWidget
						.getEditingDomain(), tableInstance, TableinstancePackage.eINSTANCE
						.getTableInstance_Rows(), tableInstance.getRows().get(i));
				compoundCommand.append(removeRowCommand);
			}
		}
		CompoundCommand updateColumnCommand;
		updateColumnCommand = createRemoveUselessColumnsCommand(natTableWidget,
				toBeRemoved);
		// An empty command is not executable
		if (updateColumnCommand != null) {
			compoundCommand.append(updateColumnCommand);
		}
		return compoundCommand;
	}
	
	/**
	 * This method generate a command to remove useless columns.
	 * @param natTableWidget
	 * @param toBeRemoved index of the lines that are planned to be removed 
	 * @return null if non change is needed.
	 * @throws CoreException
	 */
	public static CompoundCommand createRemoveUselessColumnsCommand(
			final NatTableWidget natTableWidget, final List<Integer> toBeRemoved)
			throws CoreException {
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		TableInstance tableInstance = natTableWidget.getTableInstance();
		EditingDomain editingDomain  = natTableWidget.getEditingDomain();
		List<Row> rowsToRemove = new ArrayList<Row>();
		if (toBeRemoved != null) {
			for (Integer i : toBeRemoved) {
				rowsToRemove.add(tableInstance.getRows().get(Integer.valueOf(i)));
			}
		}
		CompoundCommand result = createRemoveUselessColumnsCommand(tableInstance, rowsToRemove, commandFactory, editingDomain);
		return result;
	}

	/**
	 * This method generates a command to remove useless columns.
	 * @param tableInstance
	 * @param rowsToRemove rows that are planned to be removed.
	 * @param commandFactory
	 * @param editingDomain
	 * @return null if no change is needed.
	 * @throws MultiModelQueryException
	 */
	public static CompoundCommand createRemoveUselessColumnsCommand(
			final TableInstance tableInstance, final List<Row> rowsToRemove,
			final ICommandFactory commandFactory, final EditingDomain editingDomain)
		throws MultiModelQueryException {
		List<Command> commandList = new ArrayList<Command>();
		List<Row> rowsToKeep = new ArrayList<Row>(tableInstance.getRows());
		rowsToKeep.removeAll(rowsToRemove);
		List<Column> columns = new ArrayList<Column>(tableInstance.getColumns());
		// If there is no rows, then there should not be any column
		if (rowsToKeep.isEmpty()) {
			for (Column column : columns) {
				//rmColumnCmd = remove column command
				Command rmColumnCmd = commandFactory.createRemoveCommand(
						editingDomain, tableInstance,
						TableinstancePackage.eINSTANCE.getTableInstance_Columns(), column);
				commandList.add(rmColumnCmd);
			}
		} else {
			Set<EStructuralFeature> structFeatures = getAllStructuralFeature(tableInstance,
					rowsToKeep);
			for (Column column : columns) {
				if (column instanceof FeatureColumn) {
					EStructuralFeature structuralFeature = ((FeatureColumn) column).getFeature();
					structuralFeature = (EStructuralFeature) EcoreUtil.resolve(structuralFeature, tableInstance);
					if (structuralFeature.eIsProxy()) {
						throw new UnresolvedProxyException("The current structural feature should have been resolved. " + EcoreUtil.getURI(structuralFeature)); //$NON-NLS-1$
					}
					if (!structFeatures.contains(structuralFeature)) {
						TableInstanceCommandFactory.debug(TableInstanceCommandFactory.DEBUG, "org.eclipse.emf.facet.widgets.nattable.internal.TableInstanceCommandFactory.createCheckColumnIntegrityCommand(TableInstance, List<Row>, ICommandFactory, EditingDomain): column to remove: " //$NON-NLS-1$
											+ EcoreUtil.getURI(structuralFeature));
						//rmColumnCmd = remove column command
						Command rmColumnCmd = commandFactory.createRemoveCommand(
								editingDomain, tableInstance,
								TableinstancePackage.eINSTANCE.getTableInstance_Columns(), column);
						commandList.add(rmColumnCmd);
					}
				}
			}
		}
		CompoundCommand result = null;
		if (!commandList.isEmpty()) {
			result = new CompoundCommand(commandList);
		}
		return result;
	}

	private static void debug(final boolean debug, final String message) {
		if (debug) {
			System.out.println(message); // NOPMD by gdupe on 08/12/11 19:33 // This is the regular way to send debug message.
		}
	}

	/**
	 * this method eturns the list of structural feature required to presents the chosen rows.
	 * @param tableInstance
	 * @param rows
	 * @return
	 * @throws MultiModelQueryException
	 */
	private static Set<EStructuralFeature> getAllStructuralFeature(
			final TableInstance tableInstance, final List<Row> rows) throws MultiModelQueryException {
		List<IStatus> statusList = new ArrayList<IStatus>();
		Set<EStructuralFeature> eStructuralFeatures = new HashSet<EStructuralFeature>();
		for (Row row : rows) {
			final List<EStructuralFeature> allStructuralFeatures = row.getElement().eClass().getEAllStructuralFeatures();
			eStructuralFeatures.addAll(allStructuralFeatures);
			try {
				List<Facet> appliedFacets = new ArrayList<Facet>();
				if (tableInstance instanceof TableInstance2) {
					TableInstance2 tableInstance2 = (TableInstance2) tableInstance;
					appliedFacets.addAll(tableInstance2.getFacets2());
				} else {
					appliedFacets.add(tableInstance.getFacets());
				}
				List<EStructuralFeature> facetStructuralFetures = TableInstanceCommandFactory
						.getStructuralFeatures(row.getElement(), appliedFacets);
				eStructuralFeatures.addAll(facetStructuralFetures);
			} catch (ModelQueryException e) {
				IStatus status = new Status(
						IStatus.ERROR,
						Activator.PLUGIN_ID,
						"An exception has occured while retrieving structural features of:" + row.getElement(), e); //$NON-NLS-1$
				statusList.add(status);
			}
		}

		if (!statusList.isEmpty()) {
			IStatus globalStatus = new MultiStatus(
					Activator.PLUGIN_ID,
					0,
					"An exception has occured while retrieving structural features of the eObjects", //$NON-NLS-1$
					new Exception());
			throw new MultiModelQueryException(globalStatus);
		}
		return eStructuralFeatures;
	}

	//TODO: To be factorized in an utility class in the facet API.
	//TODO: cf. Bug 352774 - getStructuralFeatures(EObject eObject, List<Facet> appliedFacets) in an utility class 
	// This is method is not absolutly requiered to fix the bug 345730 but the
	// use of the a FacetContext instance is not required to answer to this
	// question. The FacetContext is used by the table widget but if is not the
	// master component to maintain the list of applied facet. This list is
	// maintained is the tableInstance model. That why I've retrun a static
	// method method to provide this service.
	/**
	 * 
	 * @param eObject
	 * @param appliedFacets
	 * @return
	 * @throws ModelQueryException
	 */
	private static List<EStructuralFeature> getStructuralFeatures(final EObject eObject, final List<Facet> appliedFacets) throws ModelQueryException {
		EList<EStructuralFeature> result = new BasicEList<EStructuralFeature>();
		for (Facet facet : appliedFacets) {
			if (TableInstanceCommandFactory.isInstance(eObject, facet)) {
				result.addAll(facet.getEStructuralFeatures());
			}
		}
		return result;
	}
	
	//TODO: To be factorized in an utility class in the facet API.
	//TODO: cf. Bug 352773 - isInstance(EObject eObject, Facet facet) in an utility class
	// This method is a copy of
	// org.eclipse.emf.facet.infra.facet.core.FacetContext.isInstance(EObject,
	// Facet) but accessible in a static way.
	// This is method is not absolutly requiered to fix the bug 345730 but the
	// use of the a FacetContext instance is not required to answer to this
	// question. The FacetContext is used by the table widget but if is not the
	// master component to maintain the list of applied facet. This list is
	// maintained is the tableInstance model. That why I've retrun a static
	// method method to provide this service.
	private static boolean isInstance(final EObject eObject, final Facet facet) throws ModelQueryException {
		ModelQuery modelQuery = facet.getConditionQuery();
		boolean result = false;
		boolean isSuperType = false;
		for (EClass superType : facet.getESuperTypes()) {
			if (superType.isSuperTypeOf(eObject.eClass())) {
				isSuperType = true;
				break;
			}
		}
		if (isSuperType) {
			if (modelQuery == null) {
				result = true;
			} else {
				AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton()
						.getModelQueryImpl(modelQuery);
				try {
					Object queryResult = abstractModelQuery.basicEvaluate(eObject);
					if (queryResult instanceof Boolean) {
						result = ((Boolean) queryResult).booleanValue();
					} else {
						String message = "Query " + abstractModelQuery.toString() //$NON-NLS-1$
								+ " didn't return a boolean result as expected."; //$NON-NLS-1$
						Logger.logError(message, Activator.getDefault());
					}
				} catch (ModelQueryException e) {
					result = false;
					throw e;
				} catch (Exception e) {
					result = false;
					Logger.logError(e, Activator.getDefault());
					throw new ModelQueryException("FacetContext failed to execute a query", e); //$NON-NLS-1$
				}
			}
		}
		return result;
	}
	
	
	
	public static CompoundCommand createAddRowsCommand(final List<EObject> newElements,
			final NatTableWidget natTableWidget) {
		CompoundCommand compoundCommand = new CompoundCommand();
		// the EPackage for which the MetamodelView has already been created
		Set<EPackage> alreadyDone = new HashSet<EPackage>();
		TableInstance tableInstance = natTableWidget.getTableInstance();
		EditingDomain editingDomain = natTableWidget.getEditingDomain();
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		List<EStructuralFeature> processedEStructuralFeatures = new ArrayList<EStructuralFeature>();
		for (EObject eObject : newElements) {
			if (!tableInstance.getElements().contains(eObject)) {
				Row row = TableinstanceFactory.eINSTANCE.createRow();
				Command setEobjectToRowCMD = commandFactory.createSetCommand(editingDomain, row,
						TableinstancePackage.eINSTANCE.getRow_Element(), eObject);
				compoundCommand.append(setEobjectToRowCMD);
				Command addRowCMD = commandFactory.createAddCommand(editingDomain, tableInstance,
						TableinstancePackage.eINSTANCE.getTableInstance_Rows(), row);
				compoundCommand.append(addRowCMD);
				for (EStructuralFeature eStructuralFeature : eObject.eClass()
						.getEAllStructuralFeatures()) {
					if (!processedEStructuralFeatures.contains(eStructuralFeature)) {
						processedEStructuralFeatures.add(eStructuralFeature);
						if (!natTableWidget.isColumnAlreadyDeclared(eStructuralFeature)) {
							if (eStructuralFeature instanceof EReference) {
								ReferenceColumn referenceColumn = TableinstanceFactory.eINSTANCE
										.createReferenceColumn();
								referenceColumn.setReference((EReference) eStructuralFeature);
								Command cmd = commandFactory.createAddCommand(editingDomain,
										tableInstance,
										TableinstancePackage.eINSTANCE.getTableInstance_Columns(),
										referenceColumn);
								compoundCommand.append(cmd);
	
							} else if (eStructuralFeature instanceof EAttribute) {
								AttributeColumn attributeColumn = TableinstanceFactory.eINSTANCE
										.createAttributeColumn();
								attributeColumn.setAttribute((EAttribute) eStructuralFeature);
								Command cmd = commandFactory.createAddCommand(editingDomain,
										tableInstance,
										TableinstancePackage.eINSTANCE.getTableInstance_Columns(),
										attributeColumn);
								compoundCommand.append(cmd);
							}
	
							// we add the local customization file
							if (tableInstance instanceof TableInstance2) {
								List<MetamodelView> localCustoms = natTableWidget
										.getLocalCustomizations();
								EObject container = eStructuralFeature.eContainer();
								if (container != null) {
									container = container.eContainer();
									if (container instanceof EPackage) {
										if (!alreadyDone.contains(container)) {
											if (UicustomUtil.getMetamodelViewByEPackage(localCustoms,
													(EPackage) container) == null) {
												Command cmd = createMetamodelViewCommand(
														((EPackage) container).getNsURI(),
														natTableWidget);
												if (cmd.canExecute()) {
													compoundCommand.append(cmd);
												}
												alreadyDone.add((EPackage) container);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		//If need the 3 non feature column are created.
		if (!newElements.isEmpty()) {
			Command addNonFeatureColumnCommand = createAddNonFeatureColumnIfNeeded(natTableWidget);
			if (addNonFeatureColumnCommand != null) {
				compoundCommand.append(addNonFeatureColumnCommand);
			}
		}
		return compoundCommand;
	}

	/**
	 * This method returns a CompoundCommand that create the 3 non feature columns, if needed.
	 * @param natTableWidget
	 * @return null nothing to do
	 */
	private static CompoundCommand createAddNonFeatureColumnIfNeeded(final NatTableWidget natTableWidget) {
		CompoundCommand result = new CompoundCommand();
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		EditingDomain editingdomain = natTableWidget.getEditingDomain();
		TableInstance tableInstance = natTableWidget.getTableInstance();
		EContainerColumn eContainerColumn = null;
		MetaClassColumn metaClassColumn = null;
		DefaultLabelColumn defaultLabelColumn = null;
		for (Column column : tableInstance.getColumns()) {
			if (column instanceof EContainerColumn) {
				eContainerColumn = (EContainerColumn) column;
			} else if (column instanceof MetaClassColumn) {
				metaClassColumn = (MetaClassColumn) column;
			} else if (column instanceof DefaultLabelColumn) {
				defaultLabelColumn = (DefaultLabelColumn) column;
			}
		}
		if (eContainerColumn == null) {
			eContainerColumn = TableinstanceFactory.eINSTANCE.createEContainerColumn();
			Command addCommand = commandFactory.createAddCommand(editingdomain, tableInstance, TableinstancePackage.TABLE_INSTANCE__COLUMNS, eContainerColumn);
			result.append(addCommand);
		}
		if (metaClassColumn == null) {
			metaClassColumn = TableinstanceFactory.eINSTANCE.createMetaClassColumn();
			Command addCommand = commandFactory.createAddCommand(editingdomain, tableInstance, TableinstancePackage.TABLE_INSTANCE__COLUMNS, metaClassColumn);
			result.append(addCommand);
		}
		if (defaultLabelColumn == null) {
			defaultLabelColumn = TableinstanceFactory.eINSTANCE.createDefaultLabelColumn();
			Command addCommand = commandFactory.createAddCommand(editingdomain, tableInstance, TableinstancePackage.TABLE_INSTANCE__COLUMNS, defaultLabelColumn);
			result.append(addCommand);
		}
		if (result.getCommandList().isEmpty()) {
			result = null;
		}
		return result;
	}

	private static Command createMetamodelViewCommand(final String nsURI,
			final NatTableWidget natTableWidget) {
		CompoundCommand compoundCommand = new CompoundCommand();
		TableInstance tableInstance = natTableWidget.getTableInstance();
		EditingDomain editingDomain = natTableWidget.getEditingDomain();
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		MetamodelView newMetamodelView = UicustomFactory.eINSTANCE.createMetamodelView();
		Command createMetamodelView = commandFactory.createSetCommand(editingDomain,
				newMetamodelView, UicustomPackage.eINSTANCE.getMetamodelView_MetamodelURI(), nsURI);
		compoundCommand.append(createMetamodelView);

		if (tableInstance instanceof TableInstance2) {
			Command setMetamodelViewLocalCmd = commandFactory.createAddCommand(editingDomain,
					tableInstance,
					Tableinstance2Package.eINSTANCE.getTableInstance2_LocalCustomizations(),
					newMetamodelView);
			compoundCommand.append(setMetamodelViewLocalCmd);

			List<MetamodelView> views = new ArrayList<MetamodelView>();
			views.addAll(tableInstance.getCustomizations());
			// we look for the index of the local new custom
			List<MetamodelView> localCustom = natTableWidget.getLocalCustomizations();
			int i = 0;
			for (; i < views.size(); i++) {
				if (localCustom.contains(views.get(i))) {
					break;
				}
			}
			views.add(i, newMetamodelView);
			Command setMetamodelViewCmd = commandFactory.createSetCommand(editingDomain,
					tableInstance,
					TableinstancePackage.eINSTANCE.getTableInstance_Customizations(), views);
			compoundCommand.append(setMetamodelViewCmd);

		} else {
			// TODO should be removed when all tables will be TableInstance2
			Command setMetamodelView = commandFactory.createSetCommand(editingDomain,
					tableInstance,
					TableinstancePackage.eINSTANCE.getTableInstance_LocalCustomization(),
					newMetamodelView);
			compoundCommand.append(setMetamodelView);
		}
		return compoundCommand;
	}

	/**
	 * 
	 * @return null if nothing to do.
	 */
	public static Command createShowHideColumnCommand(final NatTableWidget natTableWidget,
			final List<Column> columnsToShow, final List<Column> columnsToHide,
			final boolean putOnTheTop) {
		HashMap<EClass, TypeView> typeViewMap = new HashMap<EClass, TypeView>();
		CompoundCommand compoundCommand = new CompoundCommand();
		TableInstance tableInstance = natTableWidget.getTableInstance();
		EditingDomain editingDomain = natTableWidget.getEditingDomain();
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		if (tableInstance instanceof TableInstance2) {
			for (Column current : columnsToShow) {
				if (current instanceof FeatureColumn) {
					Command tmp = getShowHideColumnCommand(natTableWidget, current, true, typeViewMap);
					if (tmp != null) {
						compoundCommand.append(tmp);
					}
				} else {
					Command cmd = commandFactory.createSetCommand(editingDomain, current,
							TableinstancePackage.eINSTANCE.getColumn_IsHidden(), false);
						compoundCommand.append(cmd);
				}
			}

			for (Column current : columnsToHide) {
				if (current instanceof FeatureColumn) {
					Command tmp = getShowHideColumnCommand(natTableWidget, current, false, typeViewMap);
					if (tmp != null) {
						compoundCommand.append(tmp);
					}
				} else {
					Command cmd = commandFactory.createSetCommand(
							natTableWidget.getEditingDomain(), current,
							TableinstancePackage.eINSTANCE.getColumn_IsHidden(), true);
						compoundCommand.append(cmd);
				}
			}
		} else {
			for (Column current : columnsToShow) {
				Command cmd = commandFactory.createSetCommand(editingDomain, current,
						TableinstancePackage.eINSTANCE.getColumn_IsHidden(), false);
					compoundCommand.append(cmd);
			}
			for (Column current : columnsToHide) {
				Command cmd = commandFactory.createSetCommand(editingDomain, current,
						TableinstancePackage.eINSTANCE.getColumn_IsHidden(), true);
					compoundCommand.append(cmd);
			}
		}
		if (putOnTheTop) {
			Command cmd = createPutLocalCustomizationOnTheTopCommand(natTableWidget);
				compoundCommand.append(cmd);
		}
		if (compoundCommand.getCommandList().isEmpty()) {
			compoundCommand = null;
		}
		return compoundCommand;
	}

	public static Command createPutLocalCustomizationOnTheTopCommand(
			final NatTableWidget natTableWidget) {
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		List<MetamodelView> locals = natTableWidget.getLocalCustomizations();
		List<MetamodelView> views = new ArrayList<MetamodelView>();
		views.addAll(natTableWidget.getTableInstance().getCustomizations());
		views.removeAll(locals);
		views.addAll(0, locals);
		return commandFactory.createSetCommand(natTableWidget.getEditingDomain(),
				natTableWidget.getTableInstance(),
				TableinstancePackage.eINSTANCE.getTableInstance_Customizations(), views);
	}

	public static Command createSetFacetsCommand(final Collection<Facet> facets,
			final NatTableWidget natTableWidget) throws CoreException {
		return createSetFacetsCommand(facets, null, natTableWidget);
	}

	public static Command createSetFacetsCommand(final Collection<Facet> facets,
			final List<EObject> newElements, final NatTableWidget natTableWidget)
			throws CoreException {
		CompoundCommand compoundCommand = new CompoundCommand();
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		TableInstance2 tableInstance = (TableInstance2) natTableWidget.getTableInstance();
		// Add new facets
		for (Facet facet : facets) {
			if (!tableInstance.getFacets2().contains(facet)) {
				Command command = commandFactory.createAddCommand(
						natTableWidget.getEditingDomain(), tableInstance,
						Tableinstance2Package.eINSTANCE.getTableInstance2_Facets2(), facet);
				compoundCommand.append(command);
			}
		}

		// Remove non referenced one
		for (Facet facet : tableInstance.getFacets2()) {
			if (!facets.contains(facet)) {
				Command command = commandFactory.createRemoveCommand(
						natTableWidget.getEditingDomain(), tableInstance,
						Tableinstance2Package.eINSTANCE.getTableInstance2_Facets2(), facet);
				compoundCommand.append(command);
			}
		}

		final Set<EReference> eReferences = new HashSet<EReference>();
		final Set<EAttribute> eAttributes = new HashSet<EAttribute>();
		List<IStatus> statusList = new ArrayList<IStatus>();
		List<EObject> elementsInTable = new ArrayList<EObject>();
		elementsInTable.addAll(tableInstance.getElements());
		if (newElements != null) {
			elementsInTable.addAll(newElements);
		}
		for (EObject eObject : elementsInTable) {
			try {
				eAttributes.addAll(natTableWidget.getFacetContext().getAttributes(eObject));
				eReferences.addAll(natTableWidget.getFacetContext().getReferences(eObject));
			} catch (ModelQueryException e) {
				IStatus status = new Status(
						IStatus.ERROR,
						Activator.PLUGIN_ID,
						"An exception has occured while retrieving structural features of:" + eObject, e); //$NON-NLS-1$
				statusList.add(status);
			}
		}
		if (!statusList.isEmpty()) {
			IStatus globalStatus = new MultiStatus(
					Activator.PLUGIN_ID,
					0,
					"An exception has occured while retrieving structural features of the eObjects", //$NON-NLS-1$
					new Exception());
			throw new CoreException(globalStatus);
		}

		// Remove outdated columns
		for (Column c : tableInstance.getColumns()) {
			if (c instanceof FacetReferenceColumn) {
				FacetReferenceColumn facetReferenceColumn = (FacetReferenceColumn) c;
				if (!eReferences.contains(facetReferenceColumn.getReference())) {
					// Remove the column
					Command command = commandFactory.createRemoveCommand(
							natTableWidget.getEditingDomain(), tableInstance,
							TableinstancePackage.eINSTANCE.getTableInstance_Columns(), c);
					compoundCommand.append(command);
				}
			} else if (c instanceof FacetAttributeColumn) {
				FacetAttributeColumn facetAttributeColumn = (FacetAttributeColumn) c;
				if (!eAttributes.contains(facetAttributeColumn.getAttribute())) {
					// Remove the column
					Command command = commandFactory.createRemoveCommand(
							natTableWidget.getEditingDomain(), tableInstance,
							TableinstancePackage.eINSTANCE.getTableInstance_Columns(), c);
					compoundCommand.append(command);
				}
			}
		}

		for (EAttribute eAttribute : eAttributes) {
			if (!natTableWidget.isColumnAlreadyDeclared(eAttribute)) {
				FacetAttributeColumn facetAttributeColumn = TableinstanceFactory.eINSTANCE
						.createFacetAttributeColumn();
				facetAttributeColumn.setAttribute((FacetAttribute) eAttribute);
				Command command = commandFactory.createAddCommand(
						natTableWidget.getEditingDomain(), tableInstance,
						TableinstancePackage.eINSTANCE.getTableInstance_Columns(),
						facetAttributeColumn);
				compoundCommand.append(command);
			}
		}

		for (EReference eReference : eReferences) {
			if (!natTableWidget.isColumnAlreadyDeclared(eReference)) {
				FacetReferenceColumn facetReferenceColumn = TableinstanceFactory.eINSTANCE
						.createFacetReferenceColumn();
				facetReferenceColumn.setReference((FacetReference) eReference);
				Command command = commandFactory.createAddCommand(
						natTableWidget.getEditingDomain(), tableInstance,
						TableinstancePackage.eINSTANCE.getTableInstance_Columns(),
						facetReferenceColumn);
				compoundCommand.append(command);
			}
		}
		if (!compoundCommand.isEmpty()) {
			return compoundCommand;
		}
		return null;
	}

	public static CompoundCommand createDropCommand(final NatTableWidget natTableWidget,
			final IStructuredSelection structuredSelection, final Object element,
			final EStructuralFeature feature) {
		EditingDomain editingDomain = natTableWidget.getEditingDomain();
		if (editingDomain == null) {
			return null;
		}
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		CompoundCommand compoundCommand = new CompoundCommand();
		if (feature.isMany()) {
			Iterator<?> iterator = structuredSelection.iterator();
			while (iterator.hasNext()) {
				Object object = iterator.next();
				Command addCommand = commandFactory.createAddCommand(editingDomain, element,
						feature, object);
				compoundCommand.append(addCommand);
			}
		} else {
			if (structuredSelection.toList().size() == 1) {
				Object firstElement = structuredSelection.getFirstElement();
				Command addCommand = commandFactory.createSetCommand(editingDomain, element,
						feature, firstElement);
				compoundCommand.append(addCommand);
			}
		}
		return compoundCommand;
	}

	/**
	 * 
	 * @param column
	 *            a column
	 * @param isVisible
	 *            the new feature value for this column
	 * @param customizedFeatureName
	 *            the customized feature name
	 * @return
	 */
	public static Command getShowHideColumnCommand(final NatTableWidget natTableWidget,
			final Column column, final Boolean isVisible, final HashMap<EClass, TypeView> typeViewMap) {
		CompoundCommand comCommand = null;
		if (column instanceof FeatureColumn
				&& natTableWidget.getTableInstance() instanceof TableInstance2) {
			FeatureColumn featureColumn = (FeatureColumn) column;
			String customizedFeatureName = "visible"; //$NON-NLS-1$
			if (TableInstanceCommandFactory.DEBUG) {
				DebugUtils.debug(featureColumn.getFeature().getName() + '.' + customizedFeatureName + ": " + isVisible); //$NON-NLS-1$
			}
			comCommand = new CompoundCommand();
			EditingDomain editingDomain = natTableWidget.getEditingDomain();
			ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE
					.getCommandFactoryFor(editingDomain);
			EStructuralFeature featureOfTheColumn = featureColumn.getFeature();
			String customViewName = featureOfTheColumn.getName();
			MetamodelView metamodelView = null;

			EObject container = featureOfTheColumn.eContainer().eContainer();
			if (!(container instanceof EPackage)) {
				throw new IllegalStateException(
						"the container of the container of the feature '" + featureOfTheColumn.getName() + "' must be an EPackage"); //$NON-NLS-1$ //$NON-NLS-2$
			}
				EPackage ePackage = (EPackage) container;
				// 1 we look for the corresponding metamodel view
				List<MetamodelView> metamodels = new ArrayList<MetamodelView>();
				metamodels = ((TableInstance2) natTableWidget.getTableInstance())
						.getLocalCustomizations();
				metamodelView = UicustomUtil.getMetamodelViewByEPackage(metamodels,
						ePackage);
				// 2 : for each element in the table, we look for if its exists
				// already a customization
				if (metamodelView == null) {
					// should not be null, because it is created when we add an
					// object in the table we write that the column is hidden on the element which
					// provides the feature :
					throw new IllegalStateException("The table state model should contains an intance of MetamodelView to customize " + ePackage.getNsURI()); //$NON-NLS-1$
				}
				EStructuralFeature feature = featureColumn.getFeature();
				EObject featureContainer = feature.eContainer();
				TypeView typeView = UicustomUtil.getTypeViewByQualifiedName(
						metamodelView.getTypes(), (EClass) featureContainer);
				CustomView customView = null;
				StaticFeatureValue featureValue = null;
				CustomViewFeature customViewFeature = null;
				CustomizableFeatures customizableFeature = null;
				// 4 We look for the customView
				if (typeView == null) {
					typeView = typeViewMap.get(featureContainer);
				}
				if (typeView != null) {
					if (featureColumn instanceof AttributeColumn
							|| featureColumn instanceof FacetAttributeColumn) {
						customView = UicustomUtil.getAttributeViewByEStructuralFeature(
								typeView.getAttributes(), featureColumn.getFeature());
						if (customView != null) {
							// 5 we look for the customViewFeature
							customViewFeature = UicustomUtil.getCustomViewFeatureByName(
									customView.getCustomizedFeatures(), customizedFeatureName);
							if (customViewFeature != null) {
								customizableFeature = customViewFeature.getCustomizedFeature();
							}
						}
					} else if (featureColumn instanceof ReferenceColumn
							|| featureColumn instanceof FacetReferenceColumn) {
						customView = UicustomUtil.getReferenceViewByEStructuralFeature(
								typeView.getReferences(), featureColumn.getFeature());
						if (customView != null) {
							// 5 we look for the customViewFeature
							customViewFeature = UicustomUtil.getCustomViewFeatureByName(
									customView.getCustomizedFeatures(), customizedFeatureName);
							if (customViewFeature != null) {
								customizableFeature = customViewFeature.getCustomizedFeature();
							}
						}
					}
				}
				// we create the elements which are null!
				if (typeView == null) {
					typeView = UicustomPackage.eINSTANCE.getUicustomFactory().createTypeView();
					typeViewMap.put((EClass) featureContainer, typeView);
					Command cmd0 = commandFactory.createAddCommand(editingDomain, metamodelView,
							UicustomPackage.eINSTANCE.getMetamodelView_Types(), typeView);
					String elementQN = ModelUtils
							.getMetaclassQualifiedName((EClass) featureContainer);
					Command cmd1 = commandFactory.createSetCommand(editingDomain, typeView,
							UicustomPackage.eINSTANCE.getTypeView_MetaclassName(), elementQN);
					comCommand.append(cmd0);
					comCommand.append(cmd1);
					if (TableInstanceCommandFactory.DEBUG) {
						DebugUtils.debug("typeView not found: " + elementQN); //$NON-NLS-1$
						DebugUtils.debug("new typeView asssigned to: " + metamodelView.getMetamodelURI()); //$NON-NLS-1$
					}
				} else {
					if (TableInstanceCommandFactory.DEBUG) {
						DebugUtils.debug("typeView found: " + typeView.getMetaclassName()); //$NON-NLS-1$
					}
				}
				// we apply the behavior to the sub-instance
				Command subInstanceCommand = commandFactory.createSetCommand(editingDomain,
						typeView, UicustomPackage.eINSTANCE.getTypeView_AppliesToSubInstances(),
						Boolean.TRUE);
				comCommand.append(subInstanceCommand);

				if (customView == null) {
					if (TableInstanceCommandFactory.DEBUG) {
						DebugUtils.debug("create AttributeView or ReferenceView"); //$NON-NLS-1$
					}
					if (featureColumn instanceof AttributeColumn
							|| featureColumn instanceof FacetAttributeColumn) {
						customView = UicustomPackage.eINSTANCE.getUicustomFactory()
								.createAttributeView();
						Command cmd2 = commandFactory.createAddCommand(editingDomain, typeView,
								UicustomPackage.eINSTANCE.getTypeView_Attributes(), customView);
						comCommand.append(cmd2);
						Command cmd3 = commandFactory.createSetCommand(editingDomain, customView,
								UicustomPackage.eINSTANCE.getAttributeView_AttributeName(),
								customViewName);
						comCommand.append(cmd3);
					} else if (featureColumn instanceof ReferenceColumn
							|| featureColumn instanceof FacetReferenceColumn) {
						customView = UicustomPackage.eINSTANCE.getUicustomFactory()
								.createReferenceView();
						Command cmd2 = commandFactory.createAddCommand(editingDomain, typeView,
								UicustomPackage.eINSTANCE.getTypeView_References(), customView);
						comCommand.append(cmd2);
						Command cmd3 = commandFactory.createSetCommand(editingDomain, customView,
								UicustomPackage.eINSTANCE.getReferenceView_ReferenceName(),
								customViewName);
						comCommand.append(cmd3);
					}
				}
				if (customViewFeature == null) {
					customViewFeature = UicustomPackage.eINSTANCE.getUicustomFactory()
							.createCustomViewFeature();
					Command cmd4 = commandFactory.createAddCommand(editingDomain, customView,
							UicustomPackage.eINSTANCE.getCustomView_CustomizedFeatures(),
							customViewFeature);
					comCommand.append(cmd4);
				}
				if (customizableFeature == null) {
					customizableFeature = CustomizableFeatures.getByName(customizedFeatureName);
					Command cmd5 = commandFactory.createSetCommand(editingDomain,
							customViewFeature,
							UicustomPackage.eINSTANCE.getCustomViewFeature_CustomizedFeature(),
							customizableFeature);
					comCommand.append(cmd5);
				}

				featureValue = UicustomPackage.eINSTANCE.getUicustomFactory()
						.createStaticFeatureValue();
				Command cmd6 = commandFactory.createSetCommand(editingDomain, featureValue,
						UicustomPackage.eINSTANCE.getStaticFeatureValue_Value(),
						Boolean.toString(isVisible));
				comCommand.append(cmd6);

				Command cmd7 = commandFactory
						.createSetCommand(editingDomain, customViewFeature,
								UicustomPackage.eINSTANCE.getCustomViewFeature_DefaultValue(),
								featureValue);
				comCommand.append(cmd7);

		}
		return comCommand;
	}

	private TableInstanceCommandFactory() {
		// Prevents instantiation
	}

}
