/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *   Nicolas Guyomar (Mia-Software) - Bug 337442 - [NatTableWidget] CreateNewElement action is not available
 *   Nicolas Guyomar (Mia-Software) - Bug 340886 - NPE in handlers
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class CreateNewElementHandler extends AbstractHandler {

	public Object execute(final ExecutionEvent event) throws ExecutionException {
		IWorkbenchPart activePart = HandlerUtil.getActivePart(event);
		if (activePart != null) {
			INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider) activePart
					.getAdapter(INatTableWidgetProvider.class);
			if (natTableWidgetPart != null) {
				natTableWidgetPart.getNatTableWidget().createNewElement();
			}
		}
		return null;
	}

	@Override
	public boolean isEnabled() {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (window != null) {
			IWorkbenchPage page = window.getActivePage();
			if (page != null) {
				IWorkbenchPart activePart = page.getActivePart();
				if (activePart != null) {
					final INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider) activePart
							.getAdapter(INatTableWidgetProvider.class);
					if (natTableWidgetPart != null) {
						INatTableWidget natTableWidget = natTableWidgetPart.getNatTableWidget();
						if (natTableWidget != null) {
							TableConfiguration tableConfiguration = natTableWidget.getTableConfiguration();
							if (tableConfiguration != null) {
								EList<InstantiationMethod> instantiationMethod = tableConfiguration.getInstantiationMethod();
								if (instantiationMethod != null) {
									return !instantiationMethod.isEmpty();
								}
							}
						}
					}
				}
			}
		}
		return false;
	}
}
