/**
 *  Copyright (c) 2011 CEA LIST.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *  
 *  Contributors:
 *      Gregoire Dupe (Mia-Software) - Bug 345730 - Deleting an element in the model breaks the table
 */
package org.eclipse.emf.facet.widgets.nattable.internal.listeners;

import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.TableInstanceCommandFactory;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.MultiModelQueryException;
import org.eclipse.emf.facet.widgets.nattable.internal.exception.MultiModelQueryRuntimeException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;

/**
 * This class is a trigger that have to called before the commit a transaction
 * editing domain. This class trigger the deletion of model elements presented
 * in the table. If this happen the corresponding rows have also to be deleted,
 * but if an undo is called it must undo the deletion of observed model elements
 * and of the deletion of the rows corresponding rows.
 * 
 * When a model element deletion is found the trigger method return a command to
 * delete the corresponding rows.
 * 
 * @since 0.1.1
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class RowDeleteTriggerListener extends TriggerListener {

	protected static final String DEBUG_OPTION = "org.eclipse.emf.facet.widgets.nattable/debug/RowDeleteTriggerListener"; //$NON-NLS-1$
	protected static final boolean DEBUG = Activator.getDefault().isDebugging()
			&& Boolean.parseBoolean(Platform.getDebugOption(RowDeleteTriggerListener.DEBUG_OPTION));
	private TableInstance tableInstance;

	public RowDeleteTriggerListener(final TableInstance tableInstance) {
		super();
		this.tableInstance = tableInstance;
	}

	@Override
	protected Command trigger(final TransactionalEditingDomain transactionalEditingDomain,
			final Notification notification) {
		if (RowDeleteTriggerListener.DEBUG) {
			System.out.println("RowDeleteTriggerListener.trigger(): notification=" + notification); //$NON-NLS-1$
		}
		CompoundCommand command = null;
		if (RowDeleteTriggerListener.DEBUG && notification.getEventType() == Notification.REMOVE) {
			System.out
					.println("RowDeleteTriggerListener.trigger(): set notification.feature=" + notification.getFeature()); //$NON-NLS-1$
			System.out
					.println("RowDeleteTriggerListener.trigger(): set notification.oldvalue=" + notification.getOldValue()); //$NON-NLS-1$
			System.out
					.println("RowDeleteTriggerListener.trigger(): set notification.notifier.type=" + notification.getNotifier().getClass().getSimpleName()); //$NON-NLS-1$
		}
		if (notification.getEventType() == Notification.REMOVE) {
			// get the rows which have to be deleted
			List<Row> rowObservingADeletedEObject = TableInstanceListenerUtils
					.getRowsRepresentingADeletedEObject(this.tableInstance.getRows());
			if (RowDeleteTriggerListener.DEBUG) {
				System.out
						.println("RowDeleteTriggerListener.trigger(): rowObservingADeletedEObject=" + rowObservingADeletedEObject); //$NON-NLS-1$
			}
			if (!rowObservingADeletedEObject.isEmpty()) {
				command = new CompoundCommand();
				ICommandFactory commadFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(transactionalEditingDomain);
				Command removeColumnCommand;
				Command removeRowCommand = new RowDeleteCommand(transactionalEditingDomain,
						rowObservingADeletedEObject);
				command.append(removeRowCommand);
				try {
					removeColumnCommand = TableInstanceCommandFactory.createRemoveUselessColumnsCommand(this.tableInstance,
							rowObservingADeletedEObject, commadFactory, transactionalEditingDomain);
					if (removeColumnCommand != null) {
						command.append(removeColumnCommand);
					}
				} catch (MultiModelQueryException e) {
					throw new MultiModelQueryRuntimeException(e);
				}
				if (!command.canExecute()) {
					throw new RuntimeException("Unexpected unexecutable command"); //$NON-NLS-1$
				}
			}
		}
		return command;
	}

	private class RowDeleteCommand extends DeleteCommand {
		public RowDeleteCommand(final EditingDomain domain, final Collection<?> collection) {
			super(domain, collection);
		}
	}

}