/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331203 - table model editor - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.painter;

import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.ImagePainter;

import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget.BodyLayerStack;
import org.eclipse.emf.facet.widgets.nattable.internal.TableLabelProvider;
import org.eclipse.swt.graphics.Image;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class CellImagePainter extends ImagePainter {

	private final TableLabelProvider labelProvider;
	private final BodyLayerStack bodyLayer;

	public CellImagePainter(final TableLabelProvider labelProvider, final BodyLayerStack bodyLayer) {
		this.labelProvider = labelProvider;
		this.bodyLayer = bodyLayer;
	}

	@Override
	protected Image getImage(final LayerCell cell, final IConfigRegistry configRegistry) {
		Object dataValue = cell.getDataValue();
		// return labelProvider.getColumnText(dataValue,
		// cell.getColumnPosition());

		ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext(
				new ColumnPositionCoordinate(cell.getLayer(), cell.getColumnPosition()),
				this.bodyLayer.getBodyDataLayer());

		return this.labelProvider.getColumnImage(dataValue, converted.getColumnPosition());
		// TODO Auto-generated method stub
		// return super.getImage(cell, configRegistry);
	}
}
