/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.infra.browser.uicore.internal;

import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class FacetToPaint {
	private static final int INITIAL_ALPHA = 255;
	private final Rectangle bounds;
	private final Facet facet;
	private int alpha = FacetToPaint.INITIAL_ALPHA;
	private final Rectangle itemBounds;
	private final Image image;
	private final boolean overlay;

	public FacetToPaint(final Rectangle bounds, final Rectangle itemBounds, final Facet facet,
			final Image image, final boolean overlay) {
		this.bounds = bounds;
		this.itemBounds = itemBounds;
		this.facet = facet;
		this.image = image;
		this.overlay = overlay;
	}

	public Rectangle getBounds() {
		return this.bounds;
	}

	public Rectangle getItemBounds() {
		return this.itemBounds;
	}

	public Facet getFacet() {
		return this.facet;
	}

	public Image getImage() {
		return this.image;
	}

	public boolean isOverlay() {
		return this.overlay;
	}

	public void setAlpha(final int alpha) {
		this.alpha = alpha;
	}

	public int getAlpha() {
		return this.alpha;
	}
}