/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.tests.internal;

import org.eclipse.emf.facet.util.emf.core.serialization.ISerializationRegistry;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializer;
import org.eclipse.emf.facet.util.emf.core.tests.internal.DummySerializableObject;
import org.eclipse.emf.facet.util.emf.core.tests.internal.DummySerializableObject2;
import org.eclipse.emf.facet.util.emf.core.tests.internal.DummySerializableObjectSubtype;
import org.eclipse.emf.facet.util.emf.core.tests.internal.TestSerializer;
import org.eclipse.emf.facet.util.emf.core.tests.internal.TestSerializerRedundantDefinition1;
import org.junit.Assert;
import org.junit.Test;

public class SerializationTests {
    @Test
    public void testSerialization() throws Exception {
        ISerializer serializer = ISerializationRegistry.INSTANCE.getSerializerFor(DummySerializableObject.class);
        Assert.assertTrue((serializer != null ? 1 : 0) != 0);
        DummySerializableObject before = new DummySerializableObject();
        before.setValue1(7);
        before.setValue2(483);
        String serialized = serializer.serialize((Object)before);
        DummySerializableObject after = (DummySerializableObject)serializer.deserialize(serialized);
        Assert.assertTrue((after.getValue1() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((after.getValue2() == 483 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializationRedundantDefinition() {
        ISerializer serializer = ISerializationRegistry.INSTANCE.getSerializerFor(DummySerializableObject2.class);
        Assert.assertTrue((serializer.deserialize(null) == TestSerializerRedundantDefinition1.definition ? 1 : 0) != 0);
    }

    @Test
    public void testSerializationRegistrySubType() {
        ISerializer serializer = ISerializationRegistry.INSTANCE.getSerializerFor(DummySerializableObjectSubtype.class);
        Assert.assertTrue((boolean)(serializer instanceof TestSerializer));
    }

    @Test
    public void testSerializationRegistryString() {
        ISerializer serializer = ISerializationRegistry.INSTANCE.getSerializerFor("org.eclipse.emf.facet.util.emf.core.tests.internal.DummySerializableObject");
        Assert.assertTrue((boolean)(serializer instanceof TestSerializer));
    }

    @Test
    public void testSerializationRegistrySubType2() {
        ISerializer serializer = ISerializationRegistry.INSTANCE.getSerializerFor("org.eclipse.emf.facet.util.emf.core.tests.internal.DummySerializableObjectSubtype");
        Assert.assertTrue((serializer == null ? 1 : 0) != 0);
    }
}

