/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread.Bug387008Test;
import org.eclipse.emf.facet.widgets.table.ui.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.ITableWidgetFactory;
import org.eclipse.emf.facet.widgets.table.ui.TableUtils;
import org.eclipse.emf.facet.widgets.table.ui.command.ITableCommandFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bug387005Test {
    private static final int NB_TO_SELECT = 3;
    private Shell sheel = null;
    private ITableWidget tableWidget;

    @Test
    public void getSelectedRowEObjects() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage ePackage = Bug387005Test.getEPackage((ResourceSet)resourceSet);
        Table table = Bug387005Test.getTable((ResourceSet)resourceSet, (List<? extends EObject>)ePackage.getEClassifiers());
        this.openTableInAShell(table);
        ArrayList<EObject> toBeselected = new ArrayList<EObject>();
        int i = 0;
        while (i < 3) {
            toBeselected.add(((Row)table.getRows().get(i)).getElement());
            ++i;
        }
        this.tableWidget.selectRows(toBeselected, false);
        List selected = this.tableWidget.getSelectedRowEObjects();
        Assert.assertEquals((String)"Rows must be selected", (long)toBeselected.size(), (long)selected.size());
        for (EObject eObject : toBeselected) {
            Assert.assertTrue((String)"Rows must be selected", (boolean)selected.contains(eObject));
        }
    }

    @Test
    public void getTableCommandFactory() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage ePackage = Bug387005Test.getEPackage((ResourceSet)resourceSet);
        Table table = Bug387005Test.getTable((ResourceSet)resourceSet, (List<? extends EObject>)ePackage.getEClassifiers());
        this.openTableInAShell(table);
        ArrayList<EObject> toBeselected = new ArrayList<EObject>();
        int i = 0;
        while (i < 3) {
            toBeselected.add(((Row)table.getRows().get(i)).getElement());
            ++i;
        }
        this.tableWidget.selectRows(toBeselected, false);
        ITableCommandFactory tableCmdFacotry = this.tableWidget.getTableCommandFactory();
        Command cmd = tableCmdFacotry.createAddRowsCommand(Collections.singletonList(ePackage));
        Assert.assertTrue((String)"The command must be executable", (boolean)cmd.canExecute());
        cmd.execute();
        Assert.assertEquals((String)"A new row must be added.", (long)(ePackage.getEClassifiers().size() + 1), (long)table.getRows().size());
    }

    protected void openTableInAShell(final Table table) {
        final Shell[] sheelPointer = new Shell[1];
        final ITableWidget[] tableWidgetPtr = new ITableWidget[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                sheelPointer[0] = new Shell();
                tableWidgetPtr[0] = ITableWidgetFactory.INSTANCE.createTableWidget((Composite)sheelPointer[0], null, table, null);
            }
        });
        this.sheel = sheelPointer[0];
        this.tableWidget = tableWidgetPtr[0];
    }

    private static Table getTable(ResourceSet resourceSet, List<? extends EObject> eObjects) {
        URI tableUri = URI.createPlatformResourceURI((String)("/" + Bug387008Test.class.getName() + "/table.xmi"), (boolean)true);
        Resource tableResouce = resourceSet.createResource(tableUri);
        Table table = TableUtils.createTableInstance(eObjects, (String)Bug387008Test.class.getSimpleName(), null, null, null);
        tableResouce.getContents().add((Object)table);
        return table;
    }

    protected static EPackage getEPackage(ResourceSet resourceSet) {
        URI modelUri = URI.createPlatformResourceURI((String)("/" + Bug387008Test.class.getName() + "/model.xmi"), (boolean)true);
        Resource modelResouce = resourceSet.createResource(modelUri);
        EPackage ePackage = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        modelResouce.getContents().add((Object)ePackage);
        return ePackage;
    }

    @After
    public void after() {
        if (this.sheel != null) {
            final Shell fShell = this.sheel;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    fShell.close();
                }
            });
        }
    }
}

