/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.facet.efacet.tests.internal.Activator;
import org.eclipse.emf.facet.efacet.tests.internal.v0_2.AbstractFacetActionTests;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class MetaFacetActionTests
extends AbstractFacetActionTests {
    private static final int BUFFER_SIZE = 1024;
    IProject testProject;

    public MetaFacetActionTests() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        this.testProject = workspace.getRoot().getProject(this.getClass().getName());
        this.testProject.create((IProgressMonitor)new NullProgressMonitor());
        this.testProject.open((IProgressMonitor)new NullProgressMonitor());
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/my.library", (IProject)this.testProject, (String)"/my.library", (Bundle)Activator.getDefault().getBundle());
        File metadateFacetSetFile = new File(Platform.getStateLocation((Bundle)Activator.getDefault().getBundle()).toOSString(), "my.efacet2");
        MetaFacetActionTests.copyFileFromBundle(Activator.getDefault().getBundle(), "/resources/v0_2/my.efacet2", metadateFacetSetFile);
        Assert.assertTrue((boolean)metadateFacetSetFile.exists());
    }

    private static String getMetaPrefix() {
        return "platform:/meta/" + Activator.getDefault().getBundle().getSymbolicName();
    }

    private String getResourcePrefix() {
        return "platform:/resource/" + this.testProject.getName();
    }

    protected URI getSerialisationModelUri() {
        return URI.createURI((String)(String.valueOf(MetaFacetActionTests.getMetaPrefix()) + '/' + "my.serialization"));
    }

    protected URI getFacetSetUri() {
        return URI.createURI((String)(String.valueOf(MetaFacetActionTests.getMetaPrefix()) + '/' + "my.efacet2"));
    }

    protected URI getLibraryUri() {
        return URI.createURI((String)(String.valueOf(this.getResourcePrefix()) + '/' + "my.library"));
    }

    public static void copyFileFromBundle(Bundle bundleContainingResources, String sourcePath, File target) throws IOException {
        FileOutputStream fos = null;
        try {
            InputStream source;
            URL url = bundleContainingResources.getResource(sourcePath);
            if (url != null) {
                source = url.openStream();
            } else {
                url = bundleContainingResources.getEntry(sourcePath);
                if (url == null) {
                    throw new IOException(String.valueOf(sourcePath) + " not found.");
                }
                source = url.openStream();
            }
            target.getParentFile().mkdirs();
            fos = new FileOutputStream(target);
            byte[] buffer = new byte[1024];
            int nbRead = source.read(buffer);
            while (nbRead != -1) {
                fos.write(buffer, 0, nbRead);
                nbRead = source.read(buffer);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

