/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.Collection;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.tests.internal.v0_2.FacetTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FacetSetDynamicLoadingTests {
    private ResourceSetImpl resourceSet;
    private IFacetSetCatalogManager catalogManager;

    @Before
    public void init() {
        this.resourceSet = new ResourceSetImpl();
        this.catalogManager = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)this.resourceSet);
    }

    @Test
    public void testAddDynamicFacetSet() throws Exception {
        int sizeBefore = this.catalogManager.getRegisteredFacetSets().size();
        FacetSet facetSet = FacetTestUtils.createFacetSet("testAddDynamicFacet_DynamicallyAddedFacetSet");
        this.catalogManager.registerFacetSet(facetSet);
        Assert.assertEquals((long)(sizeBefore + 1), (long)this.catalogManager.getRegisteredFacetSets().size());
        Assert.assertEquals((Object)facetSet, (Object)FacetUtils.getFacetSet((Collection)this.catalogManager.getRegisteredFacetSets(), (String)"testAddDynamicFacet_DynamicallyAddedFacetSet"));
    }

    @Test
    public void testAddDuplicateDynamicFacetSet() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("testAddDuplicateDynamicFacetSet_DynamicallyAddedFacetSet");
        this.catalogManager.registerFacetSet(facetSet);
        int sizeBefore = this.catalogManager.getRegisteredFacetSets().size();
        this.catalogManager.registerFacetSet(facetSet);
        Assert.assertEquals((long)sizeBefore, (long)this.catalogManager.getRegisteredFacetSets().size());
    }

    @Test
    public void testEvaluateFacetInDynamicFacetSet() throws Exception {
        FacetOperation operation = FacetTestUtils.createSingleValuedFacetOperation("testEvaluateFacetInDynamicFacetSet", (EClassifier)EcorePackage.eINSTANCE.getEString(), "test value for testEvaluateFacetInDynamicFacetSet");
        this.catalogManager.registerFacetSet((FacetSet)((Facet)operation.eContainer()).eContainer());
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)this.resourceSet);
        String result = (String)facetManager.invoke(eObject, (EOperation)operation, String.class, null, new Object[0]);
        Assert.assertEquals((Object)"test value for testEvaluateFacetInDynamicFacetSet", (Object)result);
    }
}

