/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.efacet.tests.metamodel.internal.dummyQuery.DummyQuery;
import org.eclipse.emf.facet.efacet.tests.metamodel.internal.dummyQuery.DummyQuery2;
import org.eclipse.emf.facet.efacet.tests.metamodel.internal.dummyQuery.DummyQueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetTestUtils {
    private FacetTestUtils() {
    }

    public static FacetSet createFacetSet(String facetSetName) throws Exception {
        String facetSetNsURI = "http://test/" + facetSetName;
        String facetSetNsPrefix = "nsPrefix" + facetSetName;
        FacetSet facetSet = EFacetFactory.eINSTANCE.createFacetSet();
        facetSet.setName(facetSetName);
        facetSet.setNsURI(facetSetNsURI);
        facetSet.setNsPrefix(facetSetNsPrefix);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)("dummy://" + facetSetName)));
        resource.getContents().add((Object)facetSet);
        return facetSet;
    }

    public static FacetAttribute createSingleValuedFacetAttribute(Facet facet, EClassifier attributeType, Object attributeValue) throws Exception {
        FacetAttribute facetAttribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        facetAttribute.setName("testAttribute");
        facetAttribute.setEType(attributeType);
        facetAttribute.setDerived(true);
        facet.getFacetElements().add((Object)facetAttribute);
        DummyQuery2 dummyQuery2 = DummyQueryFactory.eINSTANCE.createDummyQuery2();
        dummyQuery2.setValue(attributeValue);
        facetAttribute.setQuery((Query)dummyQuery2);
        return facetAttribute;
    }

    public static FacetAttribute createMultiValuedFacetAttribute(Facet facet, EClassifier attributeType, Collection<?> attributeValue, boolean testOldAPI) throws Exception {
        FacetAttribute facetAttribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        facetAttribute.setName("testAttribute");
        facetAttribute.setEType(attributeType);
        facetAttribute.setDerived(true);
        facetAttribute.setUpperBound(-1);
        facet.getFacetElements().add((Object)facetAttribute);
        if (testOldAPI) {
            DummyQuery dummyQuery = DummyQueryFactory.eINSTANCE.createDummyQuery();
            dummyQuery.setValue(attributeValue);
            facetAttribute.setQuery((Query)dummyQuery);
        } else {
            DummyQuery2 dummyQuery2 = DummyQueryFactory.eINSTANCE.createDummyQuery2();
            dummyQuery2.setValue(attributeValue);
            facetAttribute.setQuery((Query)dummyQuery2);
        }
        return facetAttribute;
    }

    public static FacetReference createSingleValuedFacetReference(Facet facet, EClass referenceType, EObject referencedElement, boolean testOldAPI) throws Exception {
        FacetReference facetReference = EFacetFactory.eINSTANCE.createFacetReference();
        facetReference.setName("testReference");
        facetReference.setEType((EClassifier)referenceType);
        facetReference.setDerived(true);
        facet.getFacetElements().add((Object)facetReference);
        if (testOldAPI) {
            DummyQuery dummyQuery = DummyQueryFactory.eINSTANCE.createDummyQuery();
            dummyQuery.setValue((Object)referencedElement);
            facetReference.setQuery((Query)dummyQuery);
        } else {
            DummyQuery2 dummyQuery2 = DummyQueryFactory.eINSTANCE.createDummyQuery2();
            dummyQuery2.setValue((Object)referencedElement);
            facetReference.setQuery((Query)dummyQuery2);
        }
        return facetReference;
    }

    public static FacetReference createMultiValuedFacetReference(Facet facet, EClass referenceType, Collection<? extends EObject> referencedElements, boolean testOldAPI) throws Exception {
        FacetReference facetReference = EFacetFactory.eINSTANCE.createFacetReference();
        facetReference.setName("testReference");
        facetReference.setEType((EClassifier)referenceType);
        facetReference.setDerived(true);
        facetReference.setUpperBound(-1);
        facet.getFacetElements().add((Object)facetReference);
        if (testOldAPI) {
            DummyQuery dummyQuery = DummyQueryFactory.eINSTANCE.createDummyQuery();
            dummyQuery.setValue(referencedElements);
            facetReference.setQuery((Query)dummyQuery);
        } else {
            DummyQuery2 dummyQuery2 = DummyQueryFactory.eINSTANCE.createDummyQuery2();
            dummyQuery2.setValue(referencedElements);
            facetReference.setQuery((Query)dummyQuery2);
        }
        return facetReference;
    }

    public static FacetOperation createSingleValuedFacetOperation(String facetName, EClassifier opReturnType, Object returnValue) throws Exception {
        Facet facet = FacetTestUtils.createFacet(facetName, EcorePackage.eINSTANCE.getEObject());
        FacetOperation operation = EFacetFactory.eINSTANCE.createFacetOperation();
        operation.setName("testOperation");
        operation.setEType(opReturnType);
        facet.getFacetOperations().add((Object)operation);
        DummyQuery2 dummyQuery2 = DummyQueryFactory.eINSTANCE.createDummyQuery2();
        dummyQuery2.setValue(returnValue);
        operation.setQuery((Query)dummyQuery2);
        return operation;
    }

    public static Facet createFacet(String facetName) throws Exception {
        return FacetTestUtils.createFacet(facetName, EcorePackage.eINSTANCE.getEObject());
    }

    public static Facet createFacet(String facetName, EClass extendedMetaclass) throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet(facetName);
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(extendedMetaclass);
        facet.setName(facetName);
        facetSet.getEClassifiers().add((Object)facet);
        return facet;
    }
}

