/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.tests.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationPropertiesCatalogManager;
import org.eclipse.emf.facet.custom.core.ICustomizationPropertiesCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.tests.internal.Activator;
import org.eclipse.emf.facet.custom.tests.test2.queries.JavaQueryTests;
import org.eclipse.emf.facet.custom.ui.internal.exported.ILabelPropertiesHandlerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationCatalogTest {
    private static final String EANNOTATION_LABEL = "EAnnotation -> EModelElement [org.eclipse.emf.ecore.EAnnotation]";
    private static final String CUSTOM_PROP_LABEL = "label";
    private static final String TEST1_CUSTOM_NAME = "org.eclipse.emf.facet.custom.tests.test1";
    private static final String TEST2_CUSTOM_NAME = "org.eclipse.emf.facet.custom.tests.test2";
    private static final String COMMON_CP_URI = "platform:/plugin/org.eclipse.emf.facet.custom.ui/resources/customproperties.efacet";
    protected static final String TMP_NAME = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".tmp";
    public static final File DEFAULT_FILE = new File(Platform.getStateLocation((Bundle)Activator.getDefault().getBundle()).toOSString(), TMP_NAME);

    @Test
    public void catalogManagerAccess() {
        List allCustomisations = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager((ResourceSet)new ResourceSetImpl()).getRegisteredCustomizations();
        LinkedList<Customization> customisations = new LinkedList<Customization>();
        for (Customization customization : allCustomisations) {
            if (!TEST1_CUSTOM_NAME.equals(customization.getName())) continue;
            customisations.add(customization);
        }
        Assert.assertEquals((String)"We expect to find one customization named org.eclipse.emf.facet.custom.tests.test1", (long)1L, (long)customisations.size());
    }

    @Test
    public void propertyCatalogManagerAccess() {
        ICustomizationPropertiesCatalogManager custoManager = ICustomizationPropertiesCatalogManagerFactory.INSTANCE.getOrCreateCustomizationPropertiesCatalogManager((ResourceSet)new ResourceSetImpl());
        List customProperties = custoManager.getAllRegisteredCustomizationPropertySet();
        FacetSet commonsCP = null;
        for (FacetSet facetSet : customProperties) {
            URI uri = facetSet.eResource().getURI();
            if (!uri.toString().equals(COMMON_CP_URI)) continue;
            commonsCP = facetSet;
            break;
        }
        Assert.assertNotNull((String)"We expect to find in the catalog the common custom properties having for URI: platform:/plugin/org.eclipse.emf.facet.custom.ui/resources/customproperties.efacet", commonsCP);
    }

    @Test
    public void getLabelOf1() throws CustomizationException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        ICustomizationManager customizationMgr = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager((ResourceSet)resourceSet);
        EClass chosenEobject = EcorePackage.eINSTANCE.getEAnnotation();
        ICustomizationPropertiesCatalogManager custoManager = ICustomizationPropertiesCatalogManagerFactory.INSTANCE.getOrCreateCustomizationPropertiesCatalogManager((ResourceSet)resourceSet);
        List customProperties = custoManager.getCustomizationPropertiesByName(CUSTOM_PROP_LABEL);
        FacetOperation customProperty = null;
        for (FacetOperation facetOperation : customProperties) {
            if (!facetOperation.eResource().getURI().toString().equals(COMMON_CP_URI)) continue;
            customProperty = facetOperation;
            break;
        }
        Assert.assertNotNull((String)"We expect that one customization property is named labelin platform:/plugin/org.eclipse.emf.facet.custom.ui/resources/customproperties.efacet", customProperty);
        Object value = customizationMgr.getCustomValueOf((EObject)chosenEobject, customProperty, Object.class);
        Assert.assertEquals((String)"We expect that the label of the chosen EObject is EAnnotation -> EModelElement [org.eclipse.emf.ecore.EAnnotation]", (Object)EANNOTATION_LABEL, (Object)value);
    }

    public void getLabelOf2() throws CustomizationException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        List<Customization> customisations = CustomizationCatalogTest.getCustomizationsByName((ResourceSet)resourceSet, TEST2_CUSTOM_NAME);
        Assert.assertEquals((String)"We expect to find one customization named org.eclipse.emf.facet.custom.tests.test1", (long)customisations.size(), (long)1L);
        Customization customization = customisations.get(0);
        ICustomizationManager customizationMgr = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager((ResourceSet)resourceSet);
        customizationMgr.getManagedCustomizations().add(0, customization);
        EClass chosenEobject = EcorePackage.eINSTANCE.getEAnnotation();
        FacetOperation customProperty = ILabelPropertiesHandlerFactory.DEFAULT.createLabelPropertiesHandler(customizationMgr).getLabelProperty();
        Assert.assertNotNull((String)"We expect that one customization property is named label", (Object)customProperty);
        Object value = customizationMgr.getCustomValueOf((EObject)chosenEobject, customProperty, Object.class);
        Assert.assertEquals((String)("We expect that the value is returned by the Java query named " + JavaQueryTests.class.getName()), (Object)"hello", (Object)value);
    }

    private static List<Customization> getCustomizationsByName(ResourceSet resourceSet, String name) {
        ICustomizationCatalogManager customCatalogMgr = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(resourceSet);
        ArrayList<Customization> result = new ArrayList<Customization>();
        for (Customization customization : customCatalogMgr.getRegisteredCustomizations()) {
            if (!name.equals(customization.getName())) continue;
            result.add(customization);
        }
        return result;
    }
}

