/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.columnRename;

import net.sourceforge.nattable.style.editor.AbstractEditorPanel;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnLabelPanel
extends AbstractEditorPanel<String> {
    private Text textField;
    private final String columnLabel;
    private final String newColumnLabel;

    public ColumnLabelPanel(Composite parent, String columnLabel, String newColumnLabel) {
        super(parent, 0);
        this.columnLabel = columnLabel;
        this.newColumnLabel = newColumnLabel;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText("Original");
        Label originalLabel = new Label((Composite)this, 0);
        originalLabel.setText(this.columnLabel);
        Label renameLabel = new Label((Composite)this, 0);
        renameLabel.setText("Rename");
        this.textField = new Text((Composite)this, 2048);
        GridData gridData = new GridData(200, 15);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.textField.setLayoutData((Object)gridData);
        if (StringUtils.isNotEmpty((String)this.newColumnLabel)) {
            this.textField.setText(this.newColumnLabel);
        }
    }

    @Override
    public void edit(String newColumnHeaderLabel) throws Exception {
        if (StringUtils.isNotEmpty((String)newColumnHeaderLabel)) {
            this.textField.setText(newColumnHeaderLabel);
        }
    }

    @Override
    public String getEditorName() {
        return "Column label";
    }

    @Override
    public String getNewValue() {
        if (this.textField.isEnabled() && StringUtils.isNotEmpty((String)this.textField.getText())) {
            return this.textField.getText();
        }
        return null;
    }
}

