/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupReorderLayer;
import net.sourceforge.nattable.group.command.ReorderColumnsAndGroupsCommand;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.reorder.command.MultiColumnReorderCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderColumnsAndGroupsCommandHandler
extends AbstractLayerCommandHandler<ReorderColumnsAndGroupsCommand> {
    private final ColumnGroupReorderLayer columnGroupReorderLayer;

    public ReorderColumnsAndGroupsCommandHandler(ColumnGroupReorderLayer columnGroupReorderLayer) {
        this.columnGroupReorderLayer = columnGroupReorderLayer;
    }

    @Override
    public Class<ReorderColumnsAndGroupsCommand> getCommandClass() {
        return ReorderColumnsAndGroupsCommand.class;
    }

    @Override
    protected boolean doCommand(ReorderColumnsAndGroupsCommand command) {
        ILayer underlyingLayer = this.columnGroupReorderLayer.getUnderlyingLayer();
        ArrayList<String> groupsProcessed = new ArrayList<String>();
        List<Integer> fromColumnPositions = command.getFromColumnPositions();
        ArrayList<Integer> fromColumnPositionsWithGroupColumns = new ArrayList<Integer>();
        for (Integer fromColumnPosition : fromColumnPositions) {
            int fromColumnIndex = underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
            ColumnGroupModel model = this.columnGroupReorderLayer.getModel();
            if (model.isPartOfAGroup(fromColumnIndex)) {
                String groupName = model.getColumnGroupNameForIndex(fromColumnIndex);
                if (groupsProcessed.contains(groupName)) continue;
                groupsProcessed.add(groupName);
                fromColumnPositionsWithGroupColumns.addAll(this.columnGroupReorderLayer.getColumnGroupPositions(fromColumnIndex));
                continue;
            }
            fromColumnPositionsWithGroupColumns.add(fromColumnPosition);
        }
        return underlyingLayer.doCommand(new MultiColumnReorderCommand(this.columnGroupReorderLayer, fromColumnPositionsWithGroupColumns, command.getToColumnPosition()));
    }
}

