/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.exported;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.ValueColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.workbench.expression.TableTester;
import org.eclipse.ui.IWorkbenchPart;

public final class TableWidgetInternalUtils {
    private TableWidgetInternalUtils() {
    }

    public static String getColumnName(Column columnDescription) {
        String columnName;
        if (columnDescription instanceof SourceColumn) {
            columnName = Messages.NatTableWidget_queryContext;
        } else if (columnDescription instanceof FeatureColumn) {
            EStructuralFeature structuralFeature;
            FeatureColumn attributeColumn = (FeatureColumn)columnDescription;
            ETypedElement eTypedElement = attributeColumn.getFeature();
            columnName = eTypedElement instanceof EStructuralFeature ? ((structuralFeature = (EStructuralFeature)eTypedElement).isDerived() ? "/" + structuralFeature.getName() : structuralFeature.getName()) : eTypedElement.getName();
        } else if (columnDescription instanceof ValueColumn) {
            columnName = "Value";
        } else {
            Logger.logWarning((String)"Unhandled column description type", (Plugin)Activator.getDefault());
            columnName = "";
        }
        return columnName;
    }

    public static ETypedElement getPresentabilityQuery(Table tableInstance) {
        TableConfiguration tableConfiguration;
        ETypedElement presentabilityQuery = null;
        presentabilityQuery = tableInstance.getCanBePresentedInTheTable();
        if (presentabilityQuery == null && (tableConfiguration = tableInstance.getTableConfiguration()) != null) {
            presentabilityQuery = tableConfiguration.getCanBePresentedInTheTable();
        }
        return presentabilityQuery;
    }

    public static boolean testIsTableEditor(IWorkbenchPart part) {
        return TableTester.testIsTableEditor(part);
    }
}

