/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.swtbot;

import java.io.IOException;
import java.util.List;
import net.sourceforge.nattable.NatTable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.swtbot.SWTBotNatTable;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class NatTableUITests {
    private static final String RESOURCES_TEST_UI_RESOURCES = "/resources/v0_2/testUiResources/";
    private static final int TIMEOUT = 30000;
    private static final int PREF_TIMEOUT = 30000;
    private static final int PREF_TYPE_INTERVAL = 10;
    private static final String PROJECT_NAME = "tableTestProject";
    private static final String ECORE_TABLE_FILE_NAME = "_test_tableEcoreTest2.table";
    private static final String ECORE_FILE_NAME = "_test_EcoreModel.ecore";
    private boolean actionsNotified;

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.TIMEOUT = 30000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
    }

    @Before
    public void beforeTests() throws CoreException, IOException {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject testProject = workspace.getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/testUiResources/_test_tableEcoreTest2.table", (IProject)testProject, (String)"/_test_tableEcoreTest2.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/testUiResources/_test_EcoreModel.ecore", (IProject)testProject, (String)"/_test_EcoreModel.ecore", (Bundle)bundle);
    }

    private void addQueryColumn() throws Exception {
        SWTBotUtils.executeCommand((String)"org.eclipse.emf.facet.widgets.table.addColumnsCommand");
    }

    @Test(timeout=30000L)
    public void testCopySelectionToClipboard() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        final SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.getNatTable().selectColumn(1);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidget ITableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                ITableWidget2.copySelectionToClipboard();
                Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                String textData = (String)clipboard.getContents((Transfer)textTransfer);
                String newline = System.getProperty("line.separator");
                Assert.assertEquals((Object)("[Label]" + newline + "Class1" + newline + "Class2" + newline + "Class3" + newline + "MyPackage"), (Object)textData);
            }
        });
    }

    @Test(timeout=30000L)
    public void testIsColumnSelected() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        final SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.getNatTable().selectColumn(1);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidget ITableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertTrue((boolean)ITableWidget2.isColumnSelected());
            }
        });
        this.getNatTable().click(1, 1, 0);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidget ITableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertFalse((boolean)ITableWidget2.isColumnSelected());
            }
        });
    }

    @Test(timeout=30000L)
    public void testIsSelectedCellEditable() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        final SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.getNatTable().click(1, 5, 0);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidget ITableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertTrue((boolean)ITableWidget2.isSelectedCellEditable());
            }
        });
        this.getNatTable().click(1, 4, 0);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidget ITableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertTrue((boolean)ITableWidget2.isSelectedCellEditable());
            }
        });
        this.getNatTable().click(1, 3, 0);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidget ITableWidget2 = NatTableUITests.this.getNatTableWidget(editor);
                Assert.assertFalse((boolean)ITableWidget2.isSelectedCellEditable());
            }
        });
    }

    @Test(timeout=30000L)
    @Ignore
    public void testOpenLoadCustomizationDialog() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        ITableWidget natTableWidget2 = this.getNatTableWidget(editor);
        EditingDomain editingDomain = this.getEditingDomain(editor);
        EList custom = natTableWidget2.getTable().getCustomizations();
        Assert.assertEquals((long)1L, (long)custom.size());
        SWTBotUtils.getToolbarButton((String)"Load a Customization", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBot dialogBot1 = bot.shell("Load Customizations").bot();
        SWTBotUtils.captureScreenShot((String)"1 opened Load Customizations dialog");
        final SWTBotTree availableCustomTree = dialogBot1.treeWithLabel("Available Customizations");
        SWTBotTree loadedCustomTree = dialogBot1.treeWithLabel("Feature");
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return availableCustomTree.rowCount() != 1 || !"Loading...".equals(availableCustomTree.getAllItems()[0].getText());
            }

            public String getFailureMessage() {
                return "waiting for customizations tree to load";
            }
        });
        SWTBotUtils.captureScreenShot((String)"2 Load Customizations dialog finished loading");
        int availableCustomCount = availableCustomTree.getAllItems().length;
        int loadedCustomCount = loadedCustomTree.getAllItems().length;
        Assert.assertTrue((loadedCustomCount >= 1 ? 1 : 0) != 0);
        availableCustomTree.select(new int[]{0});
        dialogBot1.button(">").click();
        Assert.assertEquals((long)(availableCustomCount - 1), (long)availableCustomTree.getAllItems().length);
        dialogBot1.button("OK").click();
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        editingDomain.getCommandStack().undo();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)custom);
        editingDomain.getCommandStack().redo();
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        SWTBotUtils.getToolbarButton((String)"Load a Customization", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBot dialogBot = bot.shell("Load Customizations").bot();
        SWTBotTree loadedCustomTree2 = dialogBot.treeWithLabel("Feature");
        SWTBotUtils.waitUntilNotEmpty((SWTBotTree)loadedCustomTree2, (int)30000);
        loadedCustomTree2.setFocus();
        loadedCustomTree2.getAllItems()[0].select();
        dialogBot.button("<").click();
        SWTBot warningDialogBot = bot.shell("Load Customizations Warning").bot();
        warningDialogBot.button("OK").click();
        SWTBotTree loadedCustomTree3 = dialogBot.treeWithLabel("Feature");
        loadedCustomTree3.select(new int[]{1});
        dialogBot.button("<").click();
        dialogBot.button("OK").click();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)custom);
        editingDomain.getCommandStack().undo();
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        editingDomain.getCommandStack().redo();
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)custom);
        EList columns = natTableWidget2.getTable().getColumns();
        Assert.assertEquals((long)33L, (long)columns.size());
        SWTBotUtils.getToolbarButton((String)"Load a Customization", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBot dialog2Bot = bot.shell("Load Customizations").bot();
        SWTBotTree availableCustomTree2 = dialog2Bot.treeWithLabel("Available Customizations");
        availableCustomTree2.select(new String[]{"testUIEcoreUICustom"});
        dialog2Bot.button(">").click();
        dialog2Bot.checkBox().deselect();
        dialog2Bot.button("OK").click();
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        SWTBotUtils.waitUntilAssertListSize((int)33, (List)columns);
        editingDomain.getCommandStack().undo();
        SWTBotUtils.waitUntilAssertListSize((int)33, (List)columns);
        SWTBotUtils.waitUntilAssertListSize((int)1, (List)custom);
        SWTBotUtils.getToolbarButton((String)"Load a Customization", (int)0, (SWTWorkbenchBot)bot).click();
        SWTBotUtils.captureScreenShot((String)"1 opened load customization dialog");
        SWTBotShell dialogShell = bot.shell("Load Customizations");
        SWTBot dialog3Bot = dialogShell.bot();
        final SWTBotTree availableCustomTree3 = dialog3Bot.treeWithLabel("Available Customizations");
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return availableCustomTree3.rowCount() != 1 || !"Loading...".equals(availableCustomTree3.getAllItems()[0].getText());
            }

            public String getFailureMessage() {
                return "waiting for customizations tree to load";
            }
        });
        SWTBotUtils.captureScreenShot((String)"1a Load Customizations dialog finished loading");
        availableCustomTree3.select(new String[]{"testUIEcoreUICustom"});
        dialog3Bot.button(">").click();
        SWTBotUtils.captureScreenShot((String)"2 selected customization");
        dialog3Bot.checkBox().select();
        SWTBotUtils.captureScreenShot((String)"3 before clicking OK");
        dialog3Bot.button("OK").click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)dialogShell));
        SWTBotUtils.captureScreenShot((String)"4 dialog closed");
        SWTBotUtils.waitUntilAssertListSize((int)2, (List)custom);
        SWTBotUtils.waitUntilAssertListSize((int)34, (List)columns);
        editingDomain.getCommandStack().undo();
        editor.save();
    }

    @Test(timeout=30000L)
    public void testOpenLoadFacetDialog() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        this.getNatTableWidget(editor);
        this.getEditingDomain(editor);
    }

    protected void setActionsNotified(boolean value) {
        this.actionsNotified = value;
    }

    @Test(timeout=30000L)
    public void testActionDelegateRegistration() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor = bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        this.actionsNotified = false;
        final ITableWidget natTableWidget2 = this.getNatTableWidget(editor);
        IActionDelegate actiondelegate = new IActionDelegate(){

            public void selectionChanged(IAction action, ISelection selection) {
                UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                    public void run() {
                        NatTableUITests.this.setActionsNotified(true);
                    }
                });
            }

            public void run(IAction action) {
            }
        };
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                natTableWidget2.sortColumnByNameAtoZ();
                ((ITableWidgetInternal)natTableWidget2).waitForRefreshJob();
            }
        });
        bot.sleep(500L);
        Assert.assertTrue((boolean)this.actionsNotified);
        natTableWidget2.unregisterActionDelegate(actiondelegate);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                NatTableUITests.this.setActionsNotified(false);
                natTableWidget2.sortColumnsByType();
                ((ITableWidgetInternal)natTableWidget2).waitForRefreshJob();
            }
        });
        bot.sleep(500L);
        Assert.assertFalse((boolean)this.actionsNotified);
        editor.save();
    }

    protected ITableWidget getNatTableWidget(SWTBotEditor editor) {
        ITableWidgetProvider natTableWidgetPart = (ITableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(ITableWidgetProvider.class);
        return natTableWidgetPart.getTableWidget();
    }

    protected EditingDomain getEditingDomain(SWTBotEditor editor) {
        return ((IEditingDomainProvider)((IEditorReference)editor.getReference()).getPart(true)).getEditingDomain();
    }

    private SWTBotNatTable getNatTable() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        NatTable nt = (NatTable)bot.widget(WidgetMatcherFactory.widgetOfType(NatTable.class));
        return new SWTBotNatTable(nt);
    }

    private void openTableFile(String fileName) {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.captureScreenShot((String)"1");
        bot.menu("Window").menu("Show View").menu("Project Explorer").click();
        SWTBotUtils.captureScreenShot((String)"2");
        SWTBotView view = bot.viewByTitle("Project Explorer");
        view.setFocus();
        List controls = new ChildrenControlFinder((Widget)bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Tree.class));
        assert (controls.size() == 1);
        SWTBotTree tree = new SWTBotTree((Tree)controls.get(0));
        SWTBotTreeItem item = tree.expandNode(new String[]{PROJECT_NAME}).getNode(fileName).select();
        item.doubleClick();
    }
}

