/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.tests.swtbot.internal;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ContextMenuUtils {
    private ContextMenuUtils() {
    }

    public static void clickContextMenu(final Control control, final String ... menuPath) {
        final MenuItem menuItem = (MenuItem)UIThreadRunnable.syncExec((Result)new WidgetResult<MenuItem>(){

            public MenuItem run() {
                return ContextMenuUtils.getMenuItem(control, menuPath);
            }
        });
        if (menuItem == null) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            String[] stringArray = menuPath;
            int n = menuPath.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (first) {
                    first = false;
                } else {
                    builder.append(" > ");
                }
                builder.append("\"" + part + "\"");
                ++n2;
            }
            throw new WidgetNotFoundException("MenuItem with path [" + builder.toString() + "] not found.");
        }
        ContextMenuUtils.click(menuItem);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ContextMenuUtils.hide(menuItem.getParent());
            }
        });
    }

    private static MenuItem getMenuItem(Control control, String[] menuPath) {
        Menu menu = control.getMenu();
        MenuItem menuItem = null;
        String[] stringArray = menuPath;
        int n = menuPath.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            menuItem = ContextMenuUtils.getSubMenu(menu, part);
            if (menuItem == null) {
                ContextMenuUtils.hide(menu);
                break;
            }
            menu = menuItem.getMenu();
            ++n2;
        }
        return menuItem;
    }

    private static MenuItem getSubMenu(Menu menu, String subMenuText) {
        if (menu != null) {
            Matcher matcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceOf(MenuItem.class), WidgetMatcherFactory.withMnemonic((String)subMenuText)});
            menu.notifyListeners(22, new Event());
            MenuItem[] menuItemArray = menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                if (matcher.matches((Object)menuItem)) {
                    return menuItem;
                }
                ++n2;
            }
            menu.notifyListeners(23, new Event());
        }
        return null;
    }

    private static void click(final MenuItem menuItem) {
        final Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = menuItem;
        event.display = menuItem.getDisplay();
        event.type = 13;
        UIThreadRunnable.asyncExec((Display)menuItem.getDisplay(), (VoidResult)new VoidResult(){

            public void run() {
                menuItem.notifyListeners(13, event);
            }
        });
    }

    private static void hide(Menu menu) {
        menu.notifyListeners(23, new Event());
        if (menu.getParentMenu() != null) {
            ContextMenuUtils.hide(menu.getParentMenu());
        }
    }
}

