/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.tests.swtbot.internal.exported;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.tests.swtbot.internal.Activator;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;

public final class ScreenShotUtils {
    private static final String SCREENSHOTS_DIR = "screenshots";
    private static final String SCREENSHOTS_FORMAT = ".png";

    private ScreenShotUtils() {
    }

    public static void capture() {
        String fileName = String.valueOf(ScreenShotUtils.getPrefix()) + ScreenShotUtils.getMethodName(2) + SCREENSHOTS_FORMAT;
        File pictureFile = new File(ScreenShotUtils.getLocation(), fileName);
        new SWTWorkbenchBot().captureScreenshot(pictureFile.toString());
    }

    public static void capture(String imageName) {
        String fileName = String.valueOf(ScreenShotUtils.getPrefix()) + ScreenShotUtils.getMethodName(2) + ScreenShotUtils.cleanName(imageName) + SCREENSHOTS_FORMAT;
        File pictureFile = new File(ScreenShotUtils.getLocation(), fileName);
        new SWTWorkbenchBot().captureScreenshot(pictureFile.toString());
    }

    public static void capture(String imageName, int offset) {
        String fileName = String.valueOf(ScreenShotUtils.getPrefix()) + ScreenShotUtils.getMethodName(2 + offset) + ScreenShotUtils.cleanName(imageName) + SCREENSHOTS_FORMAT;
        File pictureFile = new File(ScreenShotUtils.getLocation(), fileName);
        new SWTWorkbenchBot().captureScreenshot(pictureFile.toString());
    }

    private static String getPrefix() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
        return String.valueOf(Long.toString(System.currentTimeMillis())) + '_';
    }

    private static String cleanName(String imageName) {
        return imageName.replaceAll("[\\/\\\\\\?\\%\\*\\:\\|\\\"\\<\\>\\.]", "_");
    }

    private static String getMethodName(int offset) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTrace[1 + offset];
        return String.valueOf(caller.getClassName()) + '.' + caller.getMethodName() + '_';
    }

    private static File getLocation() {
        File workspaceDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        return new File(workspaceDir, SCREENSHOTS_DIR);
    }
}

