/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.swtbot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.junit.core.internal.exported.AbstractLogListenerTest;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableEditorFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class Bug344925Test
extends AbstractLogListenerTest {
    private static final String RESOURCES_BUG344925 = "/resources/v0_2/Bug344925/";
    private static final int TIMEOUT = 30000;
    private static final String PROJECT_NAME = "projectBug344925";
    private static final String ECORE_FILE_NAME = "_Bug344925_EcoreModel.ecore";
    private static final String TABLE_CONFIGURATION_FILE_PATH = "/resources/v0_2/Bug344925/_Bug344925_EcoreTableConfiguration.tableconfiguration";
    private static final String UI_PLUGIN_ID = "org.eclipse.ui";
    private static final String CORE_RESOURCE_PLUGIN_ID = "org.eclipse.core.resources";
    private static final String CORE_JOBS_PLUGIN_ID = "org.eclipse.core.jobs";
    private static final String WIDGET_NATTABLE_PLUGIN_ID = "org.eclipse.emf.facet.widgets.table.ui.nattable";
    private static final String WIDGET_TABLE_PLUGIN_ID = "org.eclipse.emf.facet.widgets.table.ui";
    private static final int PREF_TIMEOUT = 5000;
    private static final int PREF_TYPE_INTERVAL = 10;

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.TIMEOUT = 5000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
    }

    @Before
    public void beforeTests() throws CoreException, IOException {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/Bug344925/_Bug344925_EcoreModel.ecore", (IProject)testProject, (String)"/_Bug344925_EcoreModel.ecore", (Bundle)bundle);
    }

    private void openTableFile(String fileName) {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.captureScreenShot((String)"1");
        bot.menu("Window").menu("Show View").menu("Project Explorer").click();
        SWTBotUtils.captureScreenShot((String)"2");
        SWTBotView view = bot.viewByTitle("Project Explorer");
        view.setFocus();
        List controls = new ChildrenControlFinder((Widget)bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Tree.class));
        assert (controls.size() == 1);
        SWTBotTree tree = new SWTBotTree((Tree)controls.get(0));
        final SWTBotTreeItem item = tree.expandNode(new String[]{PROJECT_NAME}).getNode(fileName).select();
        try {
            ((SWTBotMenu)UIThreadRunnable.syncExec((Result)new Result<SWTBotMenu>(){

                public SWTBotMenu run() {
                    try {
                        return item.contextMenu("Open With").menu("Other...");
                    }
                    catch (WidgetNotFoundException widgetNotFoundException) {
                        return null;
                    }
                }
            })).click();
            SWTBotTable table = bot.table();
            table.select(new String[]{"Sample Ecore Model Editor"});
            bot.button("OK").click();
        }
        catch (NullPointerException nullPointerException) {
            item.doubleClick();
        }
    }

    @Test(timeout=30000L)
    public void testBug344925() {
        this.openTableFile(ECORE_FILE_NAME);
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotEditor swtBotEditor = bot.editorByTitle(ECORE_FILE_NAME);
        swtBotEditor.setFocus();
        Assert.assertTrue((boolean)swtBotEditor.isActive());
        swtBotEditor.bot().tree().expandNode(new String[]{"platform:/resource/projectBug344925/_Bug344925_EcoreModel.ecore"}).select("MyPackage").click();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                StructuredSelection structuredSelection;
                Object fistElement;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                ISelection selection = window.getSelectionService().getSelection();
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IEditingDomainProvider editingDomainProvider = null;
                EditingDomain editingDomain = null;
                if (editor != null && editor instanceof IEditingDomainProvider) {
                    editingDomainProvider = (IEditingDomainProvider)editor;
                    editingDomain = editingDomainProvider.getEditingDomain();
                }
                if (selection instanceof StructuredSelection && (fistElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof EPackage) {
                    EPackage ePackage = (EPackage)fistElement;
                    ResourceSet resourceSet = ePackage.eResource().getResourceSet();
                    URI uri = URI.createPlatformPluginURI((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + Bug344925Test.TABLE_CONFIGURATION_FILE_PATH), (boolean)false);
                    Resource resource = resourceSet.getResource(uri, true);
                    TableConfiguration tableConfiguration = (TableConfiguration)resource.getContents().get(0);
                    ArrayList list = new ArrayList();
                    list.addAll(ePackage.getEClassifiers());
                    ITableEditorFactory.DEFAULT.openOn(list, editingDomain, "Example of customized table editor", tableConfiguration, (EObject)ePackage, null);
                }
            }
        });
        final SWTBotEditor tableEditor = bot.editorByTitle("Model Table");
        tableEditor.setFocus();
        SWTBotUtils.captureScreenShot((String)"Before to hide the column named name");
        SWTBotToolbarButton selectColumnsToHideToolbarButton = SWTBotUtils.getToolbarButton((String)"Select columns to hide", (int)0, (SWTWorkbenchBot)bot);
        selectColumnsToHideToolbarButton.click();
        bot.table().getTableItem("name").uncheck();
        SWTBotUtils.captureScreenShot((String)"After to have unchecked the item named name");
        bot.button("OK").click();
        SWTBotUtils.captureScreenShot((String)"After to have hidden the column named name");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidgetProvider natTableWidgetPart = (ITableWidgetProvider)((IEditorReference)tableEditor.getReference()).getPart(true).getAdapter(ITableWidgetProvider.class);
                ITableWidget tableWidget = natTableWidgetPart.getTableWidget();
                Column hiddenColumn = (Column)tableWidget.getTable().getColumns().get(4);
                ITableWidgetInternal tableWidgetInternal = (ITableWidgetInternal)natTableWidgetPart.getTableWidget();
                tableWidgetInternal.waitForRefreshJob();
                List visibleColumns = tableWidgetInternal.getVisibleColumnsUsingTheLayer();
                if (visibleColumns.contains(hiddenColumn)) {
                    String message = this.getStateDumpMessage(tableWidget);
                    Assert.fail((String)message);
                }
                Assert.assertFalse((boolean)visibleColumns.contains(hiddenColumn));
                IEditingDomainProvider natTableEditor = (IEditingDomainProvider)((IEditorReference)tableEditor.getReference()).getPart(false);
                CommandStack cmdStack = natTableEditor.getEditingDomain().getCommandStack();
                Assert.assertTrue((boolean)cmdStack.canUndo());
                cmdStack.undo();
            }

            private String getStateDumpMessage(ITableWidget tableWidget) {
                File file = new File(String.valueOf(this.getClass().getName()) + ".table");
                URI uri = URI.createFileURI((String)file.getAbsolutePath());
                ResourceSet resourceSet = tableWidget.getTable().eResource().getResourceSet();
                Resource r = resourceSet.createResource(uri);
                r.getContents().add((Object)EcoreUtil.copy((EObject)tableWidget.getTable()));
                try {
                    r.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return "The table model has been saved in " + file.getAbsolutePath();
            }
        });
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidgetProvider natTableWidgetPart = (ITableWidgetProvider)((IEditorReference)tableEditor.getReference()).getPart(true).getAdapter(ITableWidgetProvider.class);
                ITableWidgetInternal tableWidgetInternal = (ITableWidgetInternal)natTableWidgetPart.getTableWidget();
                tableWidgetInternal.waitForRefreshJob();
                IEditingDomainProvider natTableEditor = (IEditingDomainProvider)((IEditorReference)tableEditor.getReference()).getPart(false);
                CommandStack cmdStack = natTableEditor.getEditingDomain().getCommandStack();
                List visibleColumns = tableWidgetInternal.getVisibleColumnsUsingTheLayer();
                ITableWidget tableWidget = natTableWidgetPart.getTableWidget();
                Column hiddenColumn = (Column)tableWidget.getTable().getColumns().get(4);
                Assert.assertTrue((boolean)visibleColumns.contains(hiddenColumn));
                Assert.assertTrue((boolean)cmdStack.canRedo());
                cmdStack.redo();
            }
        });
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                ITableWidgetProvider natTableWidgetPart = (ITableWidgetProvider)((IEditorReference)tableEditor.getReference()).getPart(true).getAdapter(ITableWidgetProvider.class);
                ITableWidgetInternal tableWidgetInternal = (ITableWidgetInternal)natTableWidgetPart.getTableWidget();
                tableWidgetInternal.waitForRefreshJob();
                List visibleColumns = tableWidgetInternal.getVisibleColumnsUsingTheLayer();
                ITableWidget tableWidget = natTableWidgetPart.getTableWidget();
                Column hiddenColumn = (Column)tableWidget.getTable().getColumns().get(4);
                Assert.assertFalse((boolean)visibleColumns.contains(hiddenColumn));
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
    }

    protected Bundle[] getPluginsToListen() {
        return new Bundle[]{Platform.getBundle((String)CORE_RESOURCE_PLUGIN_ID), Platform.getBundle((String)UI_PLUGIN_ID), Platform.getBundle((String)CORE_JOBS_PLUGIN_ID), Platform.getBundle((String)WIDGET_NATTABLE_PLUGIN_ID), Platform.getBundle((String)WIDGET_TABLE_PLUGIN_ID)};
    }
}

