/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialogFactory;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialogInternal;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETypedElementsSelectionDialogTests {
    private static final String STRING_ATTRIBUTE = "stringAttribute";
    private static final String BOOLEAN_ATTRIBUTE = "booleanAttribute";
    private static final String FACET1 = "facet1";
    private static final String BUG370806 = "Bug370806";

    private <T2, D> IETypedElementSelectionDialogInternal<?> openDialog(boolean multiSelection, boolean allowEmptySelection, IDialogCallbackWithPreCommit<List<ETypedElement>, T2, D> callback) {
        Collection<FacetSet> registeredFacetSets = ETypedElementsSelectionDialogTests.getRegisteredFacetSets();
        List<ETypedElement> ecoreETypedElements = this.getEcoreETypedElements();
        IETypedElementSelectionDialogInternal dialog = (IETypedElementSelectionDialogInternal)IETypedElementSelectionDialogFactory.DEFAULT.openETypedElementSelectionDialog(ecoreETypedElements, multiSelection ? Integer.MAX_VALUE : 1, allowEmptySelection, callback, null, null, registeredFacetSets);
        return dialog;
    }

    protected static Collection<FacetSet> getRegisteredFacetSets() {
        IFacetSetCatalogManager catalogManager = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl());
        Collection registeredFacetSets = catalogManager.getRegisteredFacetSets();
        return registeredFacetSets;
    }

    private List<ETypedElement> getEcoreETypedElements() {
        ArrayList<ETypedElement> availableETypedElements = new ArrayList<ETypedElement>();
        TreeIterator eAllContents = EcorePackage.eINSTANCE.eAllContents();
        while (eAllContents.hasNext()) {
            EObject element = (EObject)eAllContents.next();
            if (!(element instanceof ETypedElement)) continue;
            ETypedElement eTypedElement = (ETypedElement)element;
            availableETypedElements.add(eTypedElement);
        }
        return availableETypedElements;
    }

    @Test
    public void testSelectSingleETypedElement() throws Exception {
        final EAttribute attribute = EcorePackage.eINSTANCE.getEClass_Abstract();
        IETypedElementSelectionDialogInternal<?> dialog = this.openDialog(false, true, new IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object>(){

            public void committed(List<ETypedElement> selection, Object precommitResult) {
                Assert.assertEquals((long)1L, (long)selection.size());
                Assert.assertEquals((Object)attribute, (Object)selection.get(0));
            }

            public Object openPrecommitDialog(List<ETypedElement> result, IDialogCallback<Object> precommitCallback) {
                return null;
            }
        });
        Assert.assertNull((Object)dialog.getFirstSelectedETypedElement());
        Assert.assertTrue((boolean)dialog.getSelectedETypedElements().isEmpty());
        dialog.setSelectedETypedElements(Collections.singletonList(attribute));
        Assert.assertEquals((Object)attribute, (Object)dialog.getFirstSelectedETypedElement());
        Assert.assertEquals((long)1L, (long)dialog.getSelectedETypedElements().size());
        Assert.assertEquals((Object)attribute, dialog.getSelectedETypedElements().get(0));
        Assert.assertTrue((boolean)dialog.isOkButtonEnabled());
        dialog.pressOk();
        Assert.assertEquals((long)0L, (long)dialog.getReturnCode());
    }

    @Test
    public void testMultiselection() throws Exception {
        final List<EStructuralFeature> selection = Arrays.asList(EcorePackage.eINSTANCE.getEClass_Abstract(), EcorePackage.eINSTANCE.getEPackage_EClassifiers());
        IETypedElementSelectionDialogInternal dialog = (IETypedElementSelectionDialogInternal)IETypedElementSelectionDialogFactory.DEFAULT.openETypedElementSelectionDialog(this.getEcoreETypedElements(), Integer.MAX_VALUE, true, (IDialogCallbackWithPreCommit)new IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object>(){

            public void committed(List<ETypedElement> dialogSelection, Object precommitResult) {
                Assert.assertEquals((long)selection.size(), (long)dialogSelection.size());
                Assert.assertTrue((boolean)dialogSelection.containsAll(selection));
            }

            public Object openPrecommitDialog(List<ETypedElement> result, IDialogCallback<Object> precommitCallback) {
                return null;
            }
        }, null, null, ETypedElementsSelectionDialogTests.getRegisteredFacetSets());
        Assert.assertNull((Object)dialog.getFirstSelectedETypedElement());
        Assert.assertTrue((boolean)dialog.getSelectedETypedElements().isEmpty());
        dialog.setSelectedETypedElements(selection);
        Assert.assertEquals((long)selection.size(), (long)dialog.getSelectedETypedElements().size());
        Assert.assertTrue((boolean)dialog.getSelectedETypedElements().containsAll(selection));
        Assert.assertTrue((boolean)dialog.isOkButtonEnabled());
        dialog.pressOk();
        Assert.assertEquals((long)0L, (long)dialog.getReturnCode());
    }

    @Test
    public void testSelectFacetElement() throws Exception {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl());
        FacetSet facetSet = FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)BUG370806);
        Facet facet1 = FacetUtils.getFacet((FacetSet)facetSet, (String)FACET1);
        final FacetAttribute booleanAttribute = (FacetAttribute)FacetUtils.getETypedElement((Facet)facet1, (String)BOOLEAN_ATTRIBUTE, FacetAttribute.class);
        IETypedElementSelectionDialogInternal dialog = (IETypedElementSelectionDialogInternal)IETypedElementSelectionDialogFactory.DEFAULT.openETypedElementSelectionDialog(this.getContainedETypedElements((EObject)facetSet), Integer.MAX_VALUE, true, (IDialogCallbackWithPreCommit)new IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object>(){

            public void committed(List<ETypedElement> selection, Object precommitResult) {
                Assert.assertEquals((long)1L, (long)selection.size());
                Assert.assertEquals((Object)booleanAttribute, (Object)selection.get(0));
            }

            public Object openPrecommitDialog(List<ETypedElement> result, IDialogCallback<Object> precommitCallback) {
                return null;
            }
        }, null, null, ETypedElementsSelectionDialogTests.getRegisteredFacetSets());
        dialog.setSelectedETypedElements(Collections.singletonList(booleanAttribute));
        Assert.assertEquals((Object)booleanAttribute, (Object)dialog.getFirstSelectedETypedElement());
        Assert.assertEquals((long)1L, (long)dialog.getSelectedETypedElements().size());
        Assert.assertEquals((Object)booleanAttribute, dialog.getSelectedETypedElements().get(0));
        Assert.assertTrue((boolean)dialog.isOkButtonEnabled());
        dialog.pressOk();
        Assert.assertEquals((long)0L, (long)dialog.getReturnCode());
    }

    private Collection<ETypedElement> getContainedETypedElements(EObject eObject) {
        ArrayList<ETypedElement> typedElements = new ArrayList<ETypedElement>();
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            EObject element = (EObject)eAllContents.next();
            if (!(element instanceof ETypedElement)) continue;
            ETypedElement eTypedElement = (ETypedElement)element;
            typedElements.add(eTypedElement);
        }
        return typedElements;
    }

    @Test
    public void testFacetElementsMultiselection() throws Exception {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl());
        FacetSet facetSet = FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)BUG370806);
        Facet facet1 = FacetUtils.getFacet((FacetSet)facetSet, (String)FACET1);
        FacetAttribute booleanAttribute = (FacetAttribute)FacetUtils.getETypedElement((Facet)facet1, (String)BOOLEAN_ATTRIBUTE, FacetAttribute.class);
        FacetAttribute stringAttribute = (FacetAttribute)FacetUtils.getETypedElement((Facet)facet1, (String)STRING_ATTRIBUTE, FacetAttribute.class);
        final List<FacetAttribute> selection = Arrays.asList(booleanAttribute, stringAttribute);
        IETypedElementSelectionDialogInternal dialog = (IETypedElementSelectionDialogInternal)IETypedElementSelectionDialogFactory.DEFAULT.openETypedElementSelectionDialog(this.getContainedETypedElements((EObject)facetSet), Integer.MAX_VALUE, true, (IDialogCallbackWithPreCommit)new IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object>(){

            public void committed(List<ETypedElement> dialogSelection, Object precommitResult) {
                Assert.assertEquals((long)selection.size(), (long)dialogSelection.size());
                Assert.assertTrue((boolean)dialogSelection.containsAll(selection));
            }

            public Object openPrecommitDialog(List<ETypedElement> result, IDialogCallback<Object> precommitCallback) {
                return null;
            }
        }, null, null, ETypedElementsSelectionDialogTests.getRegisteredFacetSets());
        dialog.setSelectedETypedElements(selection);
        Assert.assertEquals((long)selection.size(), (long)dialog.getSelectedETypedElements().size());
        Assert.assertTrue((boolean)dialog.getSelectedETypedElements().containsAll(selection));
        Assert.assertTrue((boolean)dialog.isOkButtonEnabled());
        dialog.pressOk();
        Assert.assertEquals((long)0L, (long)dialog.getReturnCode());
    }

    @Test
    public void testNotifiedOnOk() throws Exception {
        final boolean[] notified = new boolean[1];
        IETypedElementSelectionDialogInternal<?> dialog = this.openDialog(false, true, new IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object>(){

            public void committed(List<ETypedElement> selection, Object precommitResult) {
                notified[0] = true;
            }

            public Object openPrecommitDialog(List<ETypedElement> result, IDialogCallback<Object> precommitCallback) {
                return null;
            }
        });
        EAttribute attribute = EcorePackage.eINSTANCE.getEClass_Abstract();
        dialog.setSelectedETypedElements(Collections.singletonList(attribute));
        dialog.pressOk();
        Assert.assertTrue((boolean)notified[0]);
    }
}

