/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2.uithread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Book;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Library;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Writer;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.tests.internal.Activator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotDerivedSFTest {
    private static final String WRITER_EXT = "WriterExt";
    private static final String PREFACED = "prefaced";
    private static final String PREFACE = "preface";
    private static final String BOOK_EXT = "BookExt";
    private static final String ONE_TO_ONE = "OToO";
    private static final String MANY_TO_MANY = "MToM";
    private Library lib;
    private IFacetManager facetMgr;
    private FacetSet extLibFS;
    private ResourceSet resourceSet;

    @Before
    public void before() {
        this.resourceSet = new ResourceSetImpl();
        Resource libResource = this.resourceSet.getResource(NotDerivedSFTest.getLiraryUri(), true);
        this.lib = (Library)libResource.getContents().get(0);
    }

    private void initWithSerializ(Resource serResource) {
        this.facetMgr = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManagerWithSerializationResource(serResource);
        Resource extLibResource = this.resourceSet.getResource(NotDerivedSFTest.getFSUri(), true);
        this.extLibFS = (FacetSet)extLibResource.getContents().get(0);
        this.facetMgr.getManagedFacetSets().add(this.extLibFS);
    }

    private void initWithoutSerializ() {
        this.facetMgr = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(this.resourceSet);
        Resource extLibResource = this.resourceSet.getResource(NotDerivedSFTest.getFSUri(), true);
        this.extLibFS = (FacetSet)extLibResource.getContents().get(0);
        this.facetMgr.getManagedFacetSets().add(this.extLibFS);
    }

    @Test
    public void oneToOne() throws FacetManagerException {
        Resource serResource = this.resourceSet.createResource(NotDerivedSFTest.getSerializationResourceUri());
        this.initWithSerializ(serResource);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Book book1 = (Book)this.lib.getBooks().get(0);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, ONE_TO_ONE, BOOK_EXT, PREFACED), (Object)writer1, null);
        this.oneToOneAssert(writer1, book1);
        this.facetMgr.saveStructuralFeatureInstanceModel();
    }

    @Test
    public void oneToOneFOpposite() throws FacetManagerException {
        this.initWithoutSerializ();
        EList writers = this.lib.getWriters();
        EList books = this.lib.getBooks();
        Writer writer1 = (Writer)writers.get(0);
        Writer writer2 = (Writer)writers.get(1);
        Book book1 = (Book)books.get(0);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, ONE_TO_ONE, BOOK_EXT, PREFACED), (Object)writer1, null);
        Writer book1writer1 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, ONE_TO_ONE, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book1 must be linked to writer1.", (Object)writer1, (Object)book1writer1);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, ONE_TO_ONE, BOOK_EXT, PREFACED), (Object)writer2, null);
        Writer book1writer2 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, ONE_TO_ONE, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book1 must be linked to writer2.", (Object)writer2, (Object)book1writer2);
    }

    @Test
    public void oneToOneInverse() throws FacetManagerException {
        String serUriStr = String.format("platform:/plugin/%s/%s/%s/OneToOne.xmi", Activator.getDefault().getBundle().getSymbolicName(), "resources/v0_2", NotDerivedSFTest.class.getSimpleName());
        URI serUri = URI.createURI((String)serUriStr);
        Resource serResource = this.resourceSet.getResource(serUri, true);
        this.initWithSerializ(serResource);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Book book1 = (Book)this.lib.getBooks().get(0);
        this.oneToOneAssert(writer1, book1);
    }

    private void oneToOneAssert(Writer writer1, Book book1) throws FacetManagerException {
        Writer book1writer = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, ONE_TO_ONE, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book1 must be linked to writer1.", (Object)writer1, (Object)book1writer);
        Book prefacedBook = (Book)this.facetMgr.getOrInvoke((EObject)writer1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, ONE_TO_ONE, WRITER_EXT, PREFACE), Book.class);
        Assert.assertEquals((String)"The opposite reference must be assigned.", (Object)book1, (Object)prefacedBook);
    }

    @Test
    public void manyToMany() throws FacetManagerException {
        Resource serResource = this.resourceSet.createResource(NotDerivedSFTest.getSerializationResourceUri());
        this.initWithSerializ(serResource);
        EList writers = this.lib.getWriters();
        EList books = this.lib.getBooks();
        Writer writer1 = (Writer)writers.get(0);
        Writer writer2 = (Writer)writers.get(1);
        Book book1 = (Book)books.get(0);
        Book book2 = (Book)books.get(1);
        Book book3 = (Book)books.get(2);
        List<Writer> writers1 = Arrays.asList(writer1);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), writers1, null);
        List<Writer> writers2 = Arrays.asList(writer2);
        this.facetMgr.set((EObject)book2, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), writers2, null);
        List<Writer> writers1and2 = Arrays.asList(writer1, writer2);
        this.facetMgr.set((EObject)book3, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), writers1and2, null);
        this.manyToManyAssert((List<Writer>)writers, (List<Book>)books);
        this.facetMgr.saveStructuralFeatureInstanceModel();
    }

    @Test
    public void manyToManyInverse() throws FacetManagerException {
        String serUriStr = String.format("platform:/plugin/%s/%s/%s/ManyToMany.xmi", Activator.getDefault().getBundle().getSymbolicName(), "resources/v0_2", NotDerivedSFTest.class.getSimpleName());
        URI serUri = URI.createURI((String)serUriStr);
        Resource serResource = this.resourceSet.getResource(serUri, true);
        this.initWithSerializ(serResource);
        EList writers = this.lib.getWriters();
        EList books = this.lib.getBooks();
        this.manyToManyAssert((List<Writer>)writers, (List<Book>)books);
    }

    @Test
    public void manyToManyFOpposite() throws FacetManagerException {
        this.initWithoutSerializ();
        EList writers = this.lib.getWriters();
        EList books = this.lib.getBooks();
        Writer writer1 = (Writer)writers.get(0);
        Writer writer2 = (Writer)writers.get(1);
        Book book1 = (Book)books.get(0);
        List<Writer> writers1 = Arrays.asList(writer1);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), writers1, null);
        List book1writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book1 must be linked to writer1.", writers1, (Object)book1writer1);
        List<Writer> writers2 = Arrays.asList(writer2);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), writers2, null);
        List book1writer2 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book1 must be linked to writer2.", writers2, (Object)book1writer2);
        List<Writer> writers12 = Arrays.asList(writer1, writer2);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), writers12, null);
        List book1writer12 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book1 must be linked to writer1 and writer 2.", writers12, (Object)book1writer12);
    }

    private void manyToManyAssert(List<Writer> writers, List<Book> books) throws FacetManagerException {
        Writer writer1 = writers.get(0);
        Writer writer2 = writers.get(1);
        Book book1 = books.get(0);
        Book book2 = books.get(1);
        Book book3 = books.get(2);
        List<Writer> writers1 = Arrays.asList(writer1);
        List book1writer = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book1 must be linked to writer1.", writers1, (Object)book1writer);
        List<Writer> writers2 = Arrays.asList(writer2);
        List book2writer = this.facetMgr.getOrInvokeMultiValued((EObject)book2, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book2 must be linked to writer2.", writers2, (Object)book2writer);
        List<Writer> writer1And2 = Arrays.asList(writer1, writer2);
        List book3writer = this.facetMgr.getOrInvokeMultiValued((EObject)book3, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, BOOK_EXT, PREFACED), Writer.class);
        Assert.assertEquals((String)"book3 must be linked to writer1 and writer2.", writer1And2, (Object)book3writer);
        List<Book> book1And3 = Arrays.asList(book1, book3);
        List writer1Books = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, WRITER_EXT, PREFACE), Book.class);
        Assert.assertEquals((String)"The opposite reference of writer1 must be assigned to book1 and book3.", book1And3, (Object)writer1Books);
        List<Book> book2And3 = Arrays.asList(book2, book3);
        List writer2Books = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)NotDerivedSFTest.getFacetRef(this.extLibFS, MANY_TO_MANY, WRITER_EXT, PREFACE), Book.class);
        Assert.assertEquals((String)"The opposite reference of writer2 must be assigned to book2 and book3.", book2And3, (Object)writer2Books);
    }

    private static FacetReference getFacetRef(FacetSet extLibFS, String subFacetSetName, String facetName, String referenceName) {
        ArrayList<FacetSet> extLibSubFacetSet = new ArrayList<FacetSet>();
        for (EPackage ePackage : extLibFS.getESubpackages()) {
            if (!(ePackage instanceof FacetSet)) continue;
            FacetSet extLibSubFS = (FacetSet)ePackage;
            extLibSubFacetSet.add(extLibSubFS);
        }
        FacetSet subFacetSet = FacetUtils.getFacetSet(extLibSubFacetSet, (String)subFacetSetName);
        Facet facet = FacetUtils.getFacet((FacetSet)subFacetSet, (String)facetName);
        return (FacetReference)FacetUtils.getETypedElement((Facet)facet, (String)referenceName, FacetReference.class);
    }

    private static URI getSerializationResourceUri() {
        String uriStr = String.format("platform:/meta/%s/%s.xmi", Activator.getDefault().getBundle().getSymbolicName(), NotDerivedSFTest.class.getSimpleName());
        return URI.createURI((String)uriStr);
    }

    private static URI getLiraryUri() {
        String uriStr = String.format("platform:/plugin/%s/%s/%s/My.library", Activator.getDefault().getBundle().getSymbolicName(), "resources/v0_2", NotDerivedSFTest.class.getSimpleName());
        return URI.createURI((String)uriStr);
    }

    private static URI getFSUri() {
        String uriStr = String.format("platform:/plugin/%s/%s/%s/ExtendedLibrary.efacet", Activator.getDefault().getBundle().getSymbolicName(), "resources/v0_2", NotDerivedSFTest.class.getSimpleName());
        return URI.createURI((String)uriStr);
    }
}

