/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.ui.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProviderFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.emf.facet.efacet.ui.IETypedElementResultDisplayer;
import org.eclipse.emf.facet.efacet.ui.IETypedElementResultDisplayerOpener;
import org.eclipse.emf.facet.efacet.ui.internal.Activator;
import org.eclipse.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.emf.facet.efacet.ui.internal.exported.view.INavigationView;
import org.eclipse.emf.facet.efacet.ui.internal.exported.widget.IETypedElementSelectionWidget;
import org.eclipse.emf.facet.efacet.ui.internal.exported.widget.IETypedElementSelectionWidgetFactory;
import org.eclipse.emf.facet.efacet.ui.internal.view.ContextPaneMenuManager;
import org.eclipse.emf.facet.efacet.ui.internal.view.DropAdapter;
import org.eclipse.emf.facet.efacet.ui.internal.view.EditableContext;
import org.eclipse.emf.facet.efacet.ui.internal.view.NavigationViewResourceSetException;
import org.eclipse.emf.facet.efacet.ui.internal.view.QueryResultDisplayersRegistry;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.part.WorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationView
extends ViewPart
implements INavigationView {
    private static final int EXEC_BT_MIN_WIDTH = 100;
    private TreeViewer contextViewer;
    private Composite mainComposite;
    private Composite parentComposite;
    private final Set<EObject> context = new HashSet<EObject>();
    private LayoutStyle layoutStyle = LayoutStyle.Horizontal;
    private IETypedElementSelectionWidget navSelection;
    private Combo comboDisplayer;
    private EditingDomain editingDomain = null;
    private ILabelProvider labelProvider;
    private final IContentProvider contextCP = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = new Object[]{};
            if (inputElement instanceof Set) {
                Set set = (Set)inputElement;
                result = set.isEmpty() ? new Object[]{Messages.QueryExecutionView_dragAndDropHint} : set.toArray();
            }
            return result;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }
    };

    public NavigationView() {
        this.updateEditingDomain();
    }

    public void createPartControl(final Composite parent) {
        this.parentComposite = parent;
        parent.setLayout((Layout)NavigationView.gridLayoutWithNoMargins());
        this.layoutStyle = LayoutStyle.Horizontal;
        this.createMainComposite();
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                NavigationView.this.controlResized(parent);
            }
        });
        NavigationView.createContextMenu();
    }

    public void controlResized(Composite parent) {
        LayoutStyle oldLayoutStyle = this.layoutStyle;
        Point size = parent.getSize();
        this.layoutStyle = size.x > size.y ? LayoutStyle.Horizontal : LayoutStyle.Vertical;
        if (this.layoutStyle != oldLayoutStyle) {
            this.createMainComposite();
        }
    }

    protected static void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createMainComposite() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        this.mainComposite = new Composite(this.parentComposite, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)NavigationView.gridLayoutWithNoMargins());
        int direction = this.layoutStyle == LayoutStyle.Horizontal ? 256 : 512;
        SashForm sashForm = new SashForm(this.mainComposite, 0x10000 | direction);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContextGroup((Composite)sashForm);
        Composite lastGroup = new Composite((Composite)sashForm, 0);
        this.createQueryGroup(lastGroup);
        lastGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = this.layoutStyle == LayoutStyle.Horizontal ? new GridLayout(2, false) : new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        lastGroup.setLayout((Layout)gridLayout);
        this.createExecuteGroup(lastGroup);
    }

    private static GridLayout gridLayoutWithNoMargins() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    private void createQueryGroup(Composite parent) {
        Group queryGroup = new Group(parent, 0);
        queryGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        queryGroup.setText(Messages.QueryExecutionView_ETypedElementsGroup);
        GridLayout groupLayout = new GridLayout();
        queryGroup.setLayout((Layout)groupLayout);
        List eTypedElements = Collections.emptyList();
        Collection<Object> knownEPackages = Collections.emptyList();
        if (this.getResourceSet() != null) {
            eTypedElements = new ArrayList(FacetUtils.getETypedElements((ResourceSet)this.getResourceSet()));
            knownEPackages = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.getResourceSet()).getRegisteredFacetSets();
        }
        this.navSelection = IETypedElementSelectionWidgetFactory.DEFAULT.createETypedElementSelectionWidget(1, false, (Composite)queryGroup, this.getCustomizationManager(), knownEPackages);
        this.navSelection.setAvailableETypedElements(eTypedElements);
    }

    private void createContextGroup(Composite parent) {
        Group contextGroup = new Group(parent, 0);
        contextGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        contextGroup.setText(Messages.QueryExecutionView_Context);
        GridLayout groupLayout = new GridLayout();
        contextGroup.setLayout((Layout)groupLayout);
        this.createContextViewer(contextGroup);
    }

    private void createContextViewer(Group contextGroup) {
        this.contextViewer = new TreeViewer((Composite)contextGroup, 2050);
        GridData listData = new GridData(4, 4, true, true);
        this.contextViewer.getTree().setLayoutData((Object)listData);
        this.addDropSupport(this.contextViewer);
        this.createContextMenu(this.contextViewer);
        this.contextViewer.setContentProvider(this.contextCP);
        this.changeEditingDomain(this.editingDomain);
        this.contextViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.contextViewer.setInput(this.context);
        this.contextViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                return NavigationView.this.compare(object1, object2);
            }
        });
    }

    protected int compare(Object object1, Object object2) {
        String label1 = this.labelProvider.getText(object1);
        String label2 = this.labelProvider.getText(object2);
        return label1.compareToIgnoreCase(label2);
    }

    private EditableContext createEditableContext() {
        return new EditableContext(){

            public void add(EObject eObject) {
                NavigationView.this.dropEObject(eObject);
            }

            public void remove(EObject eObject) {
                NavigationView.this.removeEObject(eObject);
            }

            public void clear() {
                NavigationView.this.removeAllEObjects();
            }

            public void done() {
                NavigationView.this.refreshContextViewer();
            }
        };
    }

    protected final void dropEObject(EObject eObject) {
        try {
            this.basicAddEObject(eObject);
        }
        catch (NavigationViewResourceSetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void createContextMenu(TreeViewer treeViewer) {
        ContextPaneMenuManager menuManager = new ContextPaneMenuManager(this, this.createEditableContext(), treeViewer);
        Menu menu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
    }

    private void addDropSupport(TreeViewer viewer) {
        DropAdapter dropListener = new DropAdapter(new DropAdapter.DropAction(){

            @Override
            public void dropped(Set<EObject> eObjects) {
                NavigationView.this.addEObjects(eObjects);
            }
        });
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDropSupport(7, transfers, (DropTargetListener)dropListener);
    }

    protected final void refreshContextViewer() {
        if (this.contextViewer != null) {
            this.contextViewer.refresh();
            HashSet<EObject> toBeRemoved = new HashSet<EObject>();
            for (EObject eObject : this.context) {
                if (eObject.eResource().getResourceSet() == this.getResourceSet()) continue;
                toBeRemoved.add(eObject);
            }
            this.context.remove(toBeRemoved);
            this.contextViewer.setInput(this.context);
            if (this.contextViewer.getLabelProvider() != this.labelProvider) {
                this.contextViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            }
            this.updateQueriesInput();
        }
    }

    private void updateQueriesInput() {
        ArrayList<? extends ETypedElement> result = new ArrayList<ETypedElement>();
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        IFacetSetCatalogManager catalog = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(resourceSet);
        Collection registeredFS = catalog.getRegisteredFacetSets();
        for (FacetSet facetSet : registeredFS) {
            result.addAll(this.getETypedElements(facetSet));
        }
        this.navSelection.setAvailableETypedElements(result);
    }

    private Collection<? extends ETypedElement> getETypedElements(FacetSet facetSet) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (EClassifier eClassifier : facetSet.getEClassifiers()) {
            Facet facet;
            if (!(eClassifier instanceof Facet) || !this.isApplicableFacet(facet = (Facet)eClassifier)) continue;
            result.addAll((Collection<Object>)facet.getFacetElements());
            result.addAll((Collection<Object>)facet.getFacetOperations());
        }
        for (FacetSet subFacetSet : facetSet.getFacetSets()) {
            result.addAll(this.getETypedElements(subFacetSet));
        }
        for (EPackage subPackage : facetSet.getESubpackages()) {
            if (!(subPackage instanceof FacetSet)) continue;
            FacetSet subFacetSet = (FacetSet)subPackage;
            result.addAll(this.getETypedElements(subFacetSet));
        }
        return result;
    }

    private void createExecuteGroup(Composite parent) {
        Group executeGroup = new Group(parent, 0);
        executeGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        executeGroup.setText(Messages.QueryExecutionView_ExecuteGroup);
        executeGroup.setLayout((Layout)new GridLayout());
        this.createDisplayStyleComposite(executeGroup);
        Button buttonExecute = new Button((Composite)executeGroup, 8);
        buttonExecute.setText(Messages.QueryExecutionView_ExecuteButton);
        GridData buttonData = new GridData(0x1000000, 0, true, false);
        buttonData.minimumWidth = 100;
        buttonExecute.setLayoutData((Object)buttonData);
        buttonExecute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NavigationView.this.executeClicked();
            }
        });
    }

    protected void executeClicked() {
        ETypedElement selectedQuery = this.getSelectedQuery();
        if (selectedQuery == null) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_NoQuerySelected, (String)Messages.QueryExecutionView_SelectQueryToExecute);
        } else {
            try {
                IFacetManager facetMgr = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(this.getResourceSet());
                List results = facetMgr.batchGetOrInvoke(this.context, selectedQuery, Object.class);
                if (this.checkResult(results)) {
                    this.displayResult(results);
                }
            }
            catch (Exception e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String stack = "";
                if (stackTrace.length > 0) {
                    stack = "\nat:" + stackTrace[0].toString();
                }
                String message = e.getMessage() == null ? "" : " : " + e.getMessage();
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_ErrorExecutingQuery, (String)(String.valueOf(e.getClass().getSimpleName()) + message + stack));
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }

    private boolean checkResult(List<ETypedElementResult> results) {
        boolean result = true;
        for (ETypedElementResult modelQueryResult : results) {
            Throwable exc = modelQueryResult.getException();
            if (exc == null) continue;
            Logger.logError((Throwable)exc, (String)"Query exception", (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)this.mainComposite.getShell(), (String)Messages.QueryExecutionView_QueryException, (String)(String.valueOf(exc.getClass().getSimpleName()) + " : " + exc.getMessage()));
            result = false;
            break;
        }
        return result;
    }

    private void displayResult(List<ETypedElementResult> result) {
        String displayerName = this.comboDisplayer.getText();
        IETypedElementResultDisplayer displayer = QueryResultDisplayersRegistry.getInstance().getQueryResultDisplayer(displayerName);
        if (displayer == null) {
            String message = NLS.bind((String)"Query Displayer with name \"{0}\" not found", (Object)displayerName);
            Logger.logError((String)message, (Plugin)Activator.getDefault());
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_NoQueryDisplayer, (String)message);
        } else {
            displayer.displayETypedElementResults(result, this.editingDomain);
        }
    }

    private ETypedElement getSelectedQuery() {
        ETypedElement selectedQuery = this.navSelection.getSelectedETypedElements().get(0);
        return selectedQuery;
    }

    private void createDisplayStyleComposite(Group executeGroup) {
        Composite displayStyle = new Composite((Composite)executeGroup, 0);
        displayStyle.setLayoutData((Object)new GridData(4, 0, true, false));
        displayStyle.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(displayStyle, 0);
        label.setText(Messages.QueryExecutionView_DisplayResultIn);
        this.comboDisplayer = new Combo(displayStyle, 12);
        List<IETypedElementResultDisplayer> resultDisplayers = QueryResultDisplayersRegistry.getInstance().getQueryResultDisplayers();
        for (IETypedElementResultDisplayer namedQueryResultDisplayer : resultDisplayers) {
            this.comboDisplayer.add(namedQueryResultDisplayer.getName());
        }
        this.comboDisplayer.select(0);
        this.comboDisplayer.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    public void setFocus() {
        this.updateEditingDomain();
        this.refreshContextViewer();
    }

    private void updateEditingDomain() {
        IEditingDomainProvider edProvider;
        EditingDomain newEditingDomain;
        IWorkbenchPart part;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (part = activePage.getActivePart()) instanceof IEditingDomainProvider && (this.editingDomain != (newEditingDomain = (edProvider = (IEditingDomainProvider)part).getEditingDomain()) || this.editingDomain == null)) {
            this.changeEditingDomain(newEditingDomain);
        }
    }

    private void changeEditingDomain(EditingDomain newEditingDomain) {
        this.editingDomain = newEditingDomain;
        if (this.editingDomain == null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            BasicCommandStack commandStack = new BasicCommandStack();
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        }
        ICustomizationManager customMgr = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(this.editingDomain.getResourceSet());
        this.labelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customMgr);
    }

    public void setContext(List<EObject> eObjects) {
        this.context.clear();
        this.addEObjects(eObjects);
        this.refreshContextViewer();
    }

    public void setSelectedQueries(List<ETypedElement> queries) {
        this.navSelection.setSelectedETypedElements(queries);
    }

    public ContextInfo getContextInfo() {
        ContextInfo contextInfo = new ContextInfo(new ArrayList<EObject>(this.context));
        ISelection selection = this.contextViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structSelection) {
                if (!(selectedElement instanceof EObject)) continue;
                EObject eObject = (EObject)selectedElement;
                contextInfo.addSelectedEObject(eObject);
            }
        }
        return contextInfo;
    }

    @Override
    public void addEObjects(Collection<? extends EObject> eObjects) {
        try {
            this.basicAddEObjects(eObjects);
        }
        catch (NavigationViewResourceSetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void basicAddEObjects(Collection<? extends EObject> eObjects) throws NavigationViewResourceSetException {
        this.updateEditingDomain();
        for (EObject eObject : eObjects) {
            this.basicAddEObject(eObject);
        }
        this.refreshContextViewer();
    }

    private void basicAddEObject(EObject eObject) throws NavigationViewResourceSetException {
        Resource resource = eObject.eResource();
        ResourceSet eObjectRS = resource.getResourceSet();
        if (eObjectRS == null || this.getResourceSet() != null && !eObjectRS.equals(this.getResourceSet())) {
            throw new NavigationViewResourceSetException("Invalid resourceSet: all the eObjects added in the navigation view must be owned by the same resource set.");
        }
        this.context.add(eObject);
    }

    @Override
    public void removeEObject(EObject eObject) {
        this.context.remove(eObject);
    }

    @Override
    public void removeEObjects(List<? extends EObject> eObjects) {
        this.context.removeAll(eObjects);
    }

    @Override
    public void removeAllEObjects() {
        this.context.clear();
    }

    @Override
    public List<EClassifier> getUsableEClassifiers() {
        return null;
    }

    @Override
    public void selectETypedElement(ETypedElement eTypedElement) {
    }

    @Override
    public ETypedElement getSelectedETypedElement() {
        return null;
    }

    @Override
    public List<IETypedElementResultDisplayerOpener> getAvailableSelectedDisplayers() {
        return null;
    }

    @Override
    public void setSelectDisplayer(IETypedElementResultDisplayerOpener resultDisplayer) {
    }

    @Override
    public IETypedElementResultDisplayerOpener getSelectedDisplayer() {
        return null;
    }

    @Override
    public WorkbenchPart preform() {
        return null;
    }

    private ResourceSet getResourceSet() {
        EObject firstEObject;
        Resource eResource;
        ResourceSet resourceSet = null;
        if (this.context.size() != 0 && (eResource = (firstEObject = this.context.iterator().next()).eResource()) != null) {
            resourceSet = eResource.getResourceSet();
        }
        return resourceSet;
    }

    private ICustomizationManager getCustomizationManager() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        return ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(resourceSet);
    }

    private boolean isApplicableFacet(Facet facet) {
        EClass eobjectClass = EcorePackage.eINSTANCE.getEObject();
        boolean result = false;
        for (EObject object : this.context) {
            if (facet.getExtendedMetaclass() != null && facet.getExtendedMetaclass() != eobjectClass && !facet.getExtendedMetaclass().isSuperTypeOf(object.eClass())) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ContextInfo {
        private final List<EObject> eObjects;
        private final List<EObject> selectedEObjects = new ArrayList<EObject>();

        public ContextInfo(List<EObject> eObjects) {
            this.eObjects = eObjects;
        }

        public List<EObject> getEObjects() {
            return this.eObjects;
        }

        public void addSelectedEObject(EObject eObject) {
            this.selectedEObjects.add(eObject);
        }

        public List<EObject> getSelectedEObjects() {
            return this.selectedEObjects;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LayoutStyle {
        Horizontal,
        Vertical;

    }
}

