/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.core.tests.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.facet.util.core.internal.exported.FolderUtils;
import org.junit.Assert;
import org.junit.Test;

public class FolderUtilsTests {
    private static final String RESOURCES_FOLDER = "resources";
    private static final String RESOURCES_FILE = "resources/testFile.txt";
    private static final String PROJECT_NAME = "FolderUtilsTestsProject";

    @Test
    public void testFolderUtils() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            project2.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        IProject project = workspace.getRoot().getProject(PROJECT_NAME);
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        FolderUtils.createFolder((IFolder)project.getFolder(RESOURCES_FILE));
        File folder = new File(project.getLocation().toString(), RESOURCES_FOLDER);
        Assert.assertTrue((boolean)folder.isDirectory());
        IFolder localFolder = project.getFolder("resources/test1/test2");
        Assert.assertTrue((!localFolder.exists() ? 1 : 0) != 0);
        FolderUtils.createFolder((IFolder)localFolder);
        Assert.assertTrue((boolean)localFolder.exists());
        File tempFolder = File.createTempFile("testDir", "");
        tempFolder.delete();
        tempFolder.mkdir();
        int i = 1;
        while (i <= 13) {
            File.createTempFile("testFile" + i + "-", null, tempFolder);
            ++i;
        }
        IFolder destinationFolder = project.getFolder("resources/test1/test3");
        File destinationFolderFile = destinationFolder.getLocation().toFile();
        FolderUtils.copyFolder((File)tempFolder, (File)destinationFolderFile);
        Assert.assertTrue((destinationFolderFile.listFiles().length == 13 ? 1 : 0) != 0);
        FolderUtils.clearFolder((File)destinationFolderFile);
        Assert.assertTrue((destinationFolderFile.listFiles().length == 0 ? 1 : 0) != 0);
    }
}

