/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableEditorFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Bug354224Test {
    private static final int TIMEOUT = 30000;
    private static final String BUG_ID = Bug354224Test.class.getSimpleName().replaceAll("Test", new String());
    private static final String RESOURCE_FOLDER = "resources/v0_2/" + BUG_ID + '/';
    private static final String UML_FILE_PATH = String.valueOf(RESOURCE_FOLDER) + BUG_ID + ".uml";
    private static final String PROJECT_NAME = Bug354224Test.class.getName();
    private static final String FACET_VISIBILITY_SYMBOL = "Bug354224_visibilitySymbol";
    private static final String FACET_ENUM = "Bug354224_enum";
    private static final String FACET_ENUM_ATTRIBUTE = "facetEnum";
    private static final String VISIBILITY_SYMBOL_ATTRIBUTE = "visibilitySymbol";
    private ITableWidget tableWidget;
    private List<EObject> initialContent;
    private final List<CoreException> exceptionList = new ArrayList<CoreException>();
    private Table tableInstance;
    private int nbNonFacetColumns;

    @Before
    public void init() throws CoreException, IOException {
        this.exceptionList.clear();
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)(String.valueOf('/') + UML_FILE_PATH), (IProject)project, (String)(String.valueOf('/') + UML_FILE_PATH), (Bundle)bundle);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI umlFileUri = URI.createPlatformResourceURI((String)(String.valueOf(PROJECT_NAME) + '/' + UML_FILE_PATH), (boolean)false);
        Resource umlModelResource = resourceSet.getResource(umlFileUri, true);
        this.initialContent = new ArrayList<EObject>();
        TreeIterator iterator = umlModelResource.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof Class)) continue;
            this.initialContent.add(eObject);
        }
        Assert.assertTrue((this.initialContent.size() > 0 ? 1 : 0) != 0);
        final EditingDomain finalEditingDomain = this.initEditingDomain((ResourceSet)resourceSet);
        final List<EObject> eObjectsToAddInTheTable = this.initialContent;
        final ITableWidget[] finalNatTableWidgetList = new ITableWidget[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ITableEditorFactory.DEFAULT.openOn(eObjectsToAddInTheTable, finalEditingDomain, "", null, null, null);
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = activePage.getActiveEditor();
                ITableWidgetProvider tableWidgetProvider = (ITableWidgetProvider)editor.getAdapter(ITableWidgetProvider.class);
                finalNatTableWidgetList[0] = tableWidgetProvider.getTableWidget();
            }
        });
        this.tableWidget = finalNatTableWidgetList[0];
        this.tableInstance = this.tableWidget.getTable();
        this.nbNonFacetColumns = this.tableInstance.getColumns().size();
    }

    protected abstract EditingDomain initEditingDomain(ResourceSet var1);

    @After
    public void closeAllEditors() {
        TestUtils.closeAllEditors();
    }

    @Test(timeout=30000L)
    public void test() {
        Collection registeredFS = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.tableInstance.eResource().getResourceSet()).getRegisteredFacetSets();
        FacetSet facetSet = FacetUtils.getFacetSet((Collection)registeredFS, (String)BUG_ID);
        Facet facetVisibility = FacetUtils.getFacet((Collection)FacetUtils.getFacets((FacetSet)facetSet), (String)FACET_VISIBILITY_SYMBOL);
        Facet facetEnum = FacetUtils.getFacet((Collection)FacetUtils.getFacets((FacetSet)facetSet), (String)FACET_ENUM);
        FacetAttribute attrEnum = (FacetAttribute)FacetUtils.getETypedElement((Facet)facetEnum, (String)FACET_ENUM_ATTRIBUTE, FacetAttribute.class);
        FacetAttribute attrVisibility = (FacetAttribute)FacetUtils.getETypedElement((Facet)facetVisibility, (String)VISIBILITY_SYMBOL_ATTRIBUTE, FacetAttribute.class);
        ArrayList<ETypedElement> elements = new ArrayList<ETypedElement>();
        elements.add((ETypedElement)attrEnum);
        this.checkSetColumns(elements, Collections.singletonList(facetSet));
        elements.add((ETypedElement)attrVisibility);
        this.checkSetColumns(elements, Collections.singletonList(facetSet));
        elements.remove(facetEnum);
        this.checkSetColumns(elements, Collections.singletonList(facetSet));
        elements.remove(attrVisibility);
        this.checkSetColumns(elements, Collections.singletonList(facetSet));
        elements.add((ETypedElement)attrEnum);
        this.checkSetColumns(elements, Collections.singletonList(facetSet));
        elements.add((ETypedElement)attrVisibility);
        this.checkSetColumns(elements, Collections.singletonList(facetSet));
    }

    private void checkSetColumns(List<ETypedElement> columns, List<FacetSet> facetSets) {
        ITableWidgetInternal widget = (ITableWidgetInternal)this.tableWidget;
        widget.addColumns(columns, facetSets);
        widget.waitForRefreshJob();
        int nbColumns = this.tableInstance.getColumns().size();
        Assert.assertEquals((long)(this.nbNonFacetColumns + columns.size()), (long)nbColumns);
        int nbVisible = widget.getVisibleColumnsUsingTheLayer().size();
        Assert.assertEquals((long)(this.nbNonFacetColumns + columns.size()), (long)nbVisible);
        ((ITableWidgetInternal)this.tableWidget).removeColumns(columns);
    }
}

