/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.aggregate.tests.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.aggregate.tests.internal.TestUtils;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialogFactory;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialogInternal;
import org.eclipse.emf.facet.util.swt.internal.exported.SWTTestUtils;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetSetSelectionDialogWithAggregatesTests {
    private static Collection<FacetSet> registeredFacetSets;
    private static FacetSet aggregate;
    private static FacetSet facetSet;
    private static FacetSet custom;

    public static FacetSet getFacetSet() {
        return facetSet;
    }

    public static FacetSet getAggregate() {
        return aggregate;
    }

    public static FacetSet getCustom() {
        return custom;
    }

    @BeforeClass
    public static void init() {
        registeredFacetSets = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl()).getRegisteredFacetSets();
        facetSet = FacetUtils.getFacetSet(registeredFacetSets, (String)"Bug372626_Aggregates_facetSet");
        aggregate = FacetUtils.getFacetSet(registeredFacetSets, (String)"Bug372626_Aggregates_aggregate");
        custom = FacetUtils.getFacetSet(registeredFacetSets, (String)"Bug372626_Aggregates_custom");
    }

    private static IFacetSetSelectionDialogInternal<?> openDialog(boolean multiSelection, boolean allowEmptySelection, IDialogCallback<List<FacetSet>> callback) {
        IFacetSetSelectionDialogInternal dialog = (IFacetSetSelectionDialogInternal)IFacetSetSelectionDialogFactory.DEFAULT.openFacetSetSelectionDialog(registeredFacetSets, TestUtils.selectionMaxSize(multiSelection), allowEmptySelection, callback, null);
        return dialog;
    }

    @Test
    public void testSelectAggregate() throws Exception {
        final boolean[] okPressed = new boolean[1];
        IFacetSetSelectionDialogInternal<?> dialog = FacetSetSelectionDialogWithAggregatesTests.openDialog(true, true, new IDialogCallback<List<FacetSet>>(){

            public void committed(List<FacetSet> selection) {
                Assert.assertEquals((String)"Only the aggregate that was selected must be in the selection", (long)1L, (long)selection.size());
                Assert.assertEquals((String)"The aggregate that was selected must be in the selection", (Object)FacetSetSelectionDialogWithAggregatesTests.getAggregate(), (Object)selection.get(0));
                okPressed[0] = true;
            }
        });
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(Collections.singletonList(FacetSetSelectionDialogWithAggregatesTests.getAggregate()));
        dialog.pressOk();
        Assert.assertTrue((String)"The dialog callback must be called when pressing Ok", (boolean)okPressed[0]);
    }

    @Test
    public void testSelectFacetSet() throws Exception {
        final boolean[] okPressed = new boolean[1];
        IFacetSetSelectionDialogInternal<?> dialog = FacetSetSelectionDialogWithAggregatesTests.openDialog(true, true, new IDialogCallback<List<FacetSet>>(){

            public void committed(List<FacetSet> selection) {
                Assert.assertEquals((String)"Only the FacetSet that was selected must be in the selection", (long)1L, (long)selection.size());
                Assert.assertEquals((String)"The FacetSet that was selected must be in the selection", (Object)FacetSetSelectionDialogWithAggregatesTests.getFacetSet(), (Object)selection.get(0));
                okPressed[0] = true;
            }
        });
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(Collections.singletonList(FacetSetSelectionDialogWithAggregatesTests.getFacetSet()));
        dialog.pressOk();
        Assert.assertTrue((String)"The dialog callback must be called when pressing Ok", (boolean)okPressed[0]);
    }

    @Test
    public void testSelectCustom() throws Exception {
        final boolean[] okPressed = new boolean[1];
        IFacetSetSelectionDialogInternal<?> dialog = FacetSetSelectionDialogWithAggregatesTests.openDialog(true, true, new IDialogCallback<List<FacetSet>>(){

            public void committed(List<FacetSet> selection) {
                Assert.assertEquals((String)"Only the Customization that was selected must be in the selection", (long)1L, (long)selection.size());
                Assert.assertEquals((String)"The Customization that was selected must be in the selection", (Object)FacetSetSelectionDialogWithAggregatesTests.getCustom(), (Object)selection.get(0));
                okPressed[0] = true;
            }
        });
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(Collections.singletonList(FacetSetSelectionDialogWithAggregatesTests.getCustom()));
        dialog.pressOk();
        Assert.assertTrue((String)"The dialog callback must be called when pressing Ok", (boolean)okPressed[0]);
    }

    private static IFacetSetSelectionDialogInternal<TestPrecommitDialog> openDialogWithPrecommitCallback(boolean multiSelection, boolean allowEmptySelection, IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog> callback) {
        IFacetSetSelectionDialogInternal dialog = (IFacetSetSelectionDialogInternal)IFacetSetSelectionDialogFactory.DEFAULT.openFacetSetSelectionDialog(registeredFacetSets, TestUtils.selectionMaxSize(multiSelection), allowEmptySelection, callback, null);
        return dialog;
    }

    @Test
    public void testSelectAggregateWithPrecommitCallback() throws Exception {
        final boolean[] okPressed = new boolean[1];
        IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog> dialogCallbackWithPreCommit = new IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, TestPrecommitDialog>(){

            public void committed(List<FacetSet> selection, Boolean precommitResult) {
                Assert.assertEquals((String)"Only the aggregate that was selected must be in the selection", (long)1L, (long)selection.size());
                Assert.assertEquals((String)"The aggregate that was selected must be in the selection", (Object)FacetSetSelectionDialogWithAggregatesTests.getAggregate(), (Object)selection.get(0));
                okPressed[0] = true;
            }

            public TestPrecommitDialog openPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
                return new TestPrecommitDialog(precommitCallback);
            }
        };
        IFacetSetSelectionDialogInternal<TestPrecommitDialog> dialog = FacetSetSelectionDialogWithAggregatesTests.openDialogWithPrecommitCallback(true, false, dialogCallbackWithPreCommit);
        Assert.assertNotNull((String)"the dialog must not be null", dialog);
        dialog.setSelectedFacetSets(Collections.singletonList(FacetSetSelectionDialogWithAggregatesTests.getAggregate()));
        TestPrecommitDialog precommitDialog = (TestPrecommitDialog)dialog.pressOk();
        Assert.assertNotNull((String)"the precommit dialog must not be null", (Object)precommitDialog);
        precommitDialog.pressOk();
        Assert.assertTrue((String)"The dialog callback must be called when pressing Ok", (boolean)okPressed[0]);
    }

    @Ignore
    @Test
    public void testAggregatesGrayed() throws Exception {
        final IFacetSetSelectionDialogInternal<?> dialog = FacetSetSelectionDialogWithAggregatesTests.openDialog(true, true, new IDialogCallback<List<FacetSet>>(){

            public void committed(List<FacetSet> selection) {
                Assert.fail((String)"shouldn't be called when cancelled");
            }
        });
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.getTreeViewer().expandAll();
                TreeItem[] items = dialog.getTreeViewer().getTree().getItems();
                TreeItem aggregateItem = SWTTestUtils.findTreeItem((String)"Bug372626_Aggregates_aggregate", (TreeItem[])items);
                Assert.assertNotNull((String)"The root aggregate must be found", (Object)aggregateItem);
                Assert.assertFalse((String)"The root aggregate must not be grayed", (boolean)aggregateItem.getGrayed());
                TreeItem facetSetItem = SWTTestUtils.findTreeItem((String)"Bug372626_Aggregates_facetSet", (TreeItem[])aggregateItem.getItems());
                Assert.assertNotNull((String)"Bug372626_Aggregates_facetSet must be found", (Object)facetSetItem);
                Assert.assertTrue((String)"Bug372626_Aggregates_facetSet must be grayed", (boolean)facetSetItem.getGrayed());
                TreeItem customItem = SWTTestUtils.findTreeItem((String)"Bug372626_Aggregates_custom", (TreeItem[])aggregateItem.getItems());
                Assert.assertNotNull((String)"Bug372626_Aggregates_custom must be found", (Object)customItem);
                Assert.assertTrue((String)"Bug372626_Aggregates_custom must be grayed", (boolean)customItem.getGrayed());
            }
        });
        dialog.pressCancel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestPrecommitDialog {
        private final IDialogCallback<Boolean> precommitCallback;

        public TestPrecommitDialog(IDialogCallback<Boolean> precommitCallback) {
            this.precommitCallback = precommitCallback;
        }

        public void pressOk() {
            this.precommitCallback.committed((Object)Boolean.TRUE);
        }
    }
}

