/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.tests.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.core.internal.exported.CustomizationUtils;
import org.eclipse.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.tests.metamodel.internal.Bug376469Package.Bug376469EClass;
import org.eclipse.emf.facet.custom.tests.metamodel.internal.Bug376469Package.Bug376469PackageFactory;
import org.eclipse.emf.facet.custom.tests.test2.queries.DummyOverlay;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProviderFactory;
import org.eclipse.emf.facet.custom.ui.ImageUtils;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.swt.graphics.Image;
import org.junit.Assert;
import org.junit.Test;

public class OverlayCustomizationTest {
    private static final String FACET_SET_NAME = "Bug376469";
    private static final String FACET_NAME = "Bug376469_Facet";
    private static final String FACET_SET_OWN_ECLASS_NAME = "Bug376469_OnOwnEClass";
    private static final String FACET_OWN_ECLASS_NAME = "Bug376469_OnOwnEClass_Facet";
    private static final String FACET_CUSTOMIZATION_NAME = "Bug376469_FacetCustomization";
    private static final String OWN_FACET_CUSTOMIZATION_NAME = "Bug376469_OwnFacetCustomization";
    private static final String ECORE_ECLASS_CUSTOMIZATION_NAME = "Bug376469_EcoreEClassCustomization";
    private static final String OWN_ECLASS_CUSTOMIZATION_NAME = "Bug376469_OwnEClassCustomization";
    private static final ResourceSetImpl RESOURCE_SET = new ResourceSetImpl();

    private static ICustomizationManager initCustomization(String customName) {
        ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager((ResourceSet)RESOURCE_SET);
        List registeredCustomizations = customCatalog.getRegisteredCustomizations();
        Customization custom = CustomizationUtils.getCustomization((Collection)registeredCustomizations, (String)customName);
        Assert.assertNotNull((String)"the customization must be found", (Object)custom);
        ICustomizationManager customManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager((ResourceSet)RESOURCE_SET);
        customManager.getManagedCustomizations().add(custom);
        return customManager;
    }

    @Test
    public void testEClassOverlayCustomizationOnEcoreEClass() {
        ICustomizationManager customManager = OverlayCustomizationTest.initCustomization(ECORE_ECLASS_CUSTOMIZATION_NAME);
        ICustomizedLabelProvider customLabelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customManager);
        EClass eObject = EcorePackage.eINSTANCE.getEClass();
        Image overlay = customLabelProvider.getTopRightOverlay((Object)eObject, null);
        Assert.assertEquals((String)"the top-right overlay must be returned", (Object)ImageUtils.unwrap((IImage)DummyOverlay.getImage()), (Object)overlay);
    }

    @Test
    public void testEClassOverlayCustomizationOnOwnEClass() {
        ICustomizationManager customManager = OverlayCustomizationTest.initCustomization(OWN_ECLASS_CUSTOMIZATION_NAME);
        ICustomizedLabelProvider customLabelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customManager);
        Bug376469EClass eObject = Bug376469PackageFactory.eINSTANCE.createBug376469EClass();
        Image overlay = customLabelProvider.getTopLeftOverlay((Object)eObject, null);
        Assert.assertEquals((String)"the top-left overlay must be returned", (Object)ImageUtils.unwrap((IImage)DummyOverlay.getImage()), (Object)overlay);
    }

    @Test
    public void testFacetOverlayCustomizationOnEcoreEClass() throws Exception {
        ICustomizationManager customManager = OverlayCustomizationTest.initCustomization(FACET_CUSTOMIZATION_NAME);
        ICustomizedLabelProvider customLabelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customManager);
        EClass eObject = EcorePackage.eINSTANCE.getEClass();
        this.checkFacet((EObject)eObject, FACET_SET_NAME, FACET_NAME);
        Image overlay = customLabelProvider.getBottomMiddleOverlay((Object)eObject, null);
        Assert.assertEquals((String)"the bottom-middle overlay must be returned", (Object)ImageUtils.unwrap((IImage)DummyOverlay.getImage()), (Object)overlay);
    }

    @Test
    public void testFacetOverlayCustomizationOnOwnEClass() throws Exception {
        ICustomizationManager customManager = OverlayCustomizationTest.initCustomization(OWN_FACET_CUSTOMIZATION_NAME);
        ICustomizedLabelProvider customLabelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customManager);
        Bug376469EClass eObject = Bug376469PackageFactory.eINSTANCE.createBug376469EClass();
        this.checkFacet((EObject)eObject, FACET_SET_OWN_ECLASS_NAME, FACET_OWN_ECLASS_NAME);
        Image overlay = customLabelProvider.getTopMiddleOverlay((Object)eObject, null);
        Assert.assertEquals((String)"the top-middle overlay must be returned", (Object)ImageUtils.unwrap((IImage)DummyOverlay.getImage()), (Object)overlay);
    }

    private void checkFacet(EObject eObject, String facetSetName, String facetName) throws FacetManagerException {
        IFacetSetCatalogManager facetSetCatalogManager = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)RESOURCE_SET);
        FacetSet facetSet = FacetUtils.getFacetSet((Collection)facetSetCatalogManager.getRegisteredFacetSets(), (String)facetSetName);
        Assert.assertNotNull((String)"The facetSet must be found", (Object)facetSet);
        Facet facet = FacetUtils.getFacet((FacetSet)facetSet, (String)facetName);
        Assert.assertNotNull((String)"The facet must be found", (Object)facet);
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)RESOURCE_SET);
        Assert.assertTrue((String)"The eObject must conform to the Facet", (boolean)facetManager.isConforming(eObject, facet));
    }
}

