/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.tests.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.core.internal.exported.CustomizationUtils;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandlerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.junit.Assert;
import org.junit.Test;

public class SelectionCustomizationTest {
    private static final String ECLASS_NAME = "abc";
    private static final String CUSTOMIZATION_NAME = "Bug377866_SelectionCustomization";
    private static final ResourceSetImpl RESOURCE_SET = new ResourceSetImpl();

    private static ICustomizationManager initCustomization(String customName) {
        ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager((ResourceSet)RESOURCE_SET);
        List registeredCustomizations = customCatalog.getRegisteredCustomizations();
        Customization custom = CustomizationUtils.getCustomization((Collection)registeredCustomizations, (String)customName);
        Assert.assertNotNull((String)"the customization must be found", (Object)custom);
        ICustomizationManager customManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager((ResourceSet)RESOURCE_SET);
        customManager.getManagedCustomizations().add(custom);
        return customManager;
    }

    @Test
    public void testSelectionCustomization() throws Exception {
        ICustomizationManager customManager = SelectionCustomizationTest.initCustomization(CUSTOMIZATION_NAME);
        FacetOperation selectionProperty = ISelectionPropertiesHandlerFactory.DEFAULT.createSelectionPropertiesHandler(customManager).getSelectionProperty();
        EClass source = EcoreFactory.eINSTANCE.createEClass();
        source.setName(ECLASS_NAME);
        EOperation operation = EcoreFactory.eINSTANCE.createEOperation();
        source.getEOperations().add((Object)operation);
        EAttribute feature = EcorePackage.eINSTANCE.getENamedElement_Name();
        List result = (List)customManager.getCustomValueOf((EObject)source, (ETypedElement)feature, selectionProperty, List.class);
        Assert.assertEquals((String)"The selection customization should return a single element", (long)1L, (long)result.size());
        Assert.assertEquals((String)"The selection customization should return the source element", (Object)source, result.get(0));
        EReference feature2 = EcorePackage.eINSTANCE.getEClass_EOperations();
        List result2 = (List)customManager.getCustomValueOf((EObject)source, (ETypedElement)feature2, selectionProperty, List.class);
        Assert.assertEquals((String)"The non-customized operation should return a single element", (long)1L, (long)result2.size());
        Assert.assertEquals((String)"The non-customized operation should return the operation", (Object)operation, result2.get(0));
        ICustomizationManager noCustomManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager((ResourceSet)new ResourceSetImpl());
        List result3 = (List)noCustomManager.getCustomValueOf((EObject)source, (ETypedElement)feature, selectionProperty, List.class);
        Assert.assertEquals((String)"the default customization should return a single element", (long)1L, (long)result3.size());
        Assert.assertEquals((String)"The default customization should return the name", (Object)ECLASS_NAME, result3.get(0));
    }
}

