/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.edit.ui.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.edit.core.FacetCommandException;
import org.eclipse.emf.facet.efacet.edit.core.IFacetCommandFactory;
import org.eclipse.emf.facet.efacet.edit.ui.internal.Activator;
import org.eclipse.emf.facet.efacet.edit.ui.internal.FacetPropertyRuntimeException;
import org.eclipse.emf.facet.efacet.edit.ui.internal.Messages;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetItemPropertyDescriptor
implements IItemPropertyDescriptor {
    private final EObject eObject;
    private final EStructuralFeature feature;
    private final Object value;
    private final AdapterFactoryEditingDomain editingDomain;
    private final ILabelProvider labelProvider;
    private final IFacetManager facetManager;

    public FacetItemPropertyDescriptor(EObject eObject, EStructuralFeature structuralFeature, Object value, AdapterFactoryEditingDomain editingDomain, ILabelProvider labelProvider, IFacetManager facetManager) {
        this.eObject = eObject;
        this.feature = structuralFeature;
        this.value = value;
        this.editingDomain = editingDomain;
        this.labelProvider = labelProvider;
        this.facetManager = facetManager;
    }

    public Object getPropertyValue(Object object) {
        return this.value;
    }

    public boolean isPropertySet(Object object) {
        return ((EObject)object).eIsSet(this.feature);
    }

    public void resetPropertyValue(Object object) {
        if (this.editingDomain == null) {
            this.eObject.eUnset(this.feature);
        } else {
            CommandStack commandStack = this.editingDomain.getCommandStack();
            Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.eObject, (Object)this.feature, (Object)SetCommand.UNSET_VALUE);
            commandStack.execute(command);
        }
    }

    public boolean canSetProperty(Object object) {
        boolean result = this.editingDomain == null ? this.feature.isChangeable() : this.feature.isChangeable() && !this.editingDomain.isReadOnly(this.eObject.eResource());
        return result;
    }

    public void setPropertyValue(Object object, Object newValue) {
        if (this.editingDomain == null) {
            this.eObject.eSet(this.feature, newValue);
        } else {
            CommandStack commandStack = this.editingDomain.getCommandStack();
            try {
                Command command = IFacetCommandFactory.DEFAULT.createSetCommand(this.eObject, this.feature, newValue, (EditingDomain)this.editingDomain, this.facetManager);
                commandStack.execute(command);
            }
            catch (FacetCommandException e) {
                String objectName = this.labelProvider.getText((Object)this.eObject);
                String msg = String.format("Can't set the value %s on %s.%s", newValue, objectName, this.feature.getName());
                Logger.logError((Throwable)e, (String)msg, (Plugin)Activator.getDefault());
                throw new FacetPropertyRuntimeException(msg, e);
            }
        }
    }

    public String getCategory(Object object) {
        return null;
    }

    public String getDescription(Object object) {
        return NLS.bind((String)Messages.FacetItemPropertyDescriptor_The_xx_of_the_yy, (Object)this.feature.getName(), (Object)this.eObject.eClass().getName());
    }

    public String getDisplayName(Object object) {
        return this.feature.getName();
    }

    public String[] getFilterFlags(Object object) {
        return new String[0];
    }

    public Object getHelpContextIds(Object object) {
        return null;
    }

    public String getId(Object object) {
        return this.feature.getName();
    }

    public IItemLabelProvider getLabelProvider(Object object) {
        return new IItemLabelProvider(){

            public String getText(Object obj) {
                return FacetItemPropertyDescriptor.this.getLabelProvider().getText(obj);
            }

            public Object getImage(Object obj) {
                return FacetItemPropertyDescriptor.this.getLabelProvider().getImage(obj);
            }
        };
    }

    public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor propDescriptor) {
        return false;
    }

    public Object getFeature(Object object) {
        return this.feature;
    }

    public boolean isMany(Object object) {
        return this.feature.getUpperBound() == -1;
    }

    public Collection<?> getChoiceOfValues(Object object) {
        EClassifier eType = this.feature.getEType();
        List result = Collections.emptyList();
        if (!(eType instanceof EDataType)) {
            result = new ArrayList();
            Resource eResource = this.eObject.eResource();
            ResourceSet resourceSet = eResource.getResourceSet();
            TreeIterator allContents = resourceSet.getAllContents();
            while (allContents.hasNext()) {
                EObject choiceValue;
                Notifier notifier = (Notifier)allContents.next();
                if (!(notifier instanceof EObject) || !eType.isInstance((Object)(choiceValue = (EObject)notifier))) continue;
                result.add(choiceValue);
            }
        }
        return result;
    }

    public boolean isMultiLine(Object object) {
        return false;
    }

    public boolean isSortChoices(Object object) {
        return true;
    }

    protected ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }
}

