/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.aggregate.tests.internal;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.aggregate.metamodel.v0_2_0.aggregate.Aggregate;
import org.eclipse.emf.facet.aggregate.metamodel.v0_2_0.aggregate.internal.aggregateProxy.AggregatedFacet;
import org.eclipse.emf.facet.aggregate.metamodel.v0_2_0.aggregate.internal.aggregateProxy.AggregatedOperation;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.internal.exported.CustomizationUtils;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.EClassCustomization;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.junit.Assert;
import org.junit.Test;

public class AggregateTests {
    private static final String EXPECTED_AGGREGATE_CLASS = "org.eclipse.emf.facet.aggregate.metamodel.notgenerated.internal.AggregateImpl";

    @Test
    public void testLoadAggregateFromFacetSetCatalog() {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl());
        FacetSet aggregate = FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)"Bug372626_Aggregates_aggregate");
        AggregateTests.checkAggregate(aggregate);
    }

    @Test
    public void testLoadAggregateFromCustomizationCatalog() {
        ICustomizationCatalogManager catalogManager = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager((ResourceSet)new ResourceSetImpl());
        Customization aggregate = CustomizationUtils.getCustomization((Collection)catalogManager.getRegisteredCustomizations(), (String)"Bug372626_Aggregates_aggregate");
        AggregateTests.checkAggregate((FacetSet)aggregate);
    }

    private static void checkAggregate(FacetSet aggregate) {
        Assert.assertNotNull((String)"The Aggregate must be found", (Object)aggregate);
        Assert.assertTrue((String)"The FacetSet must be an Aggregate", (boolean)(aggregate instanceof Aggregate));
        Assert.assertTrue((String)"The Aggregate implementation must be the \"notgenerated\" one", (boolean)aggregate.getClass().getName().equals(EXPECTED_AGGREGATE_CLASS));
    }

    @Test
    public void testAggregateContents() {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl());
        Aggregate aggregate = (Aggregate)FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)"Bug372626_Aggregates_aggregate");
        EList aggregatedFacetSets = aggregate.getAggregatedFacetSets();
        Assert.assertEquals((String)"Expects 2 elements under the aggregate", (long)2L, (long)aggregatedFacetSets.size());
        Assert.assertEquals((String)"The first aggregated element must be the FacetSet", (Object)"Bug372626_Aggregates_facetSet", (Object)((FacetSet)aggregatedFacetSets.get(0)).getName());
        Assert.assertEquals((String)"The second aggregated element must be the Customization", (Object)"Bug372626_Aggregates_custom", (Object)((FacetSet)aggregatedFacetSets.get(1)).getName());
        EList facetSets = aggregate.getFacetSets();
        Assert.assertEquals((String)"Expects 2 children under the aggregate", (long)2L, (long)facetSets.size());
        Assert.assertEquals((String)"The first element must be the FacetSet", (Object)"Bug372626_Aggregates_facetSet", (Object)((FacetSet)facetSets.get(0)).getName());
        Assert.assertEquals((String)"The second element must be the Customization", (Object)"Bug372626_Aggregates_custom", (Object)((FacetSet)facetSets.get(1)).getName());
        EList facetSetClassifiers = ((FacetSet)facetSets.get(0)).getEClassifiers();
        Assert.assertEquals((String)"The aggregated FacetSet must contain one classifier", (long)1L, (long)facetSetClassifiers.size());
        Assert.assertTrue((String)"The aggregated FacetSet must contain an AggregatedFacet", (boolean)(facetSetClassifiers.get(0) instanceof AggregatedFacet));
        Assert.assertTrue((String)"The AggregatedFacet must be a Facet", (boolean)(facetSetClassifiers.get(0) instanceof Facet));
        Assert.assertNotNull((String)"The AggregatedFacet must proxy a Facet", (Object)((AggregatedFacet)facetSetClassifiers.get(0)).getFacet());
        EList customClassifiers = ((FacetSet)facetSets.get(1)).getEClassifiers();
        Assert.assertEquals((String)"The aggregated Customization must contain one classifier", (long)1L, (long)customClassifiers.size());
        Assert.assertTrue((String)"The aggregated Customization must contain an AggregatedFacet", (boolean)(customClassifiers.get(0) instanceof AggregatedFacet));
        Assert.assertTrue((String)"The AggregatedFacet must be a Facet", (boolean)(customClassifiers.get(0) instanceof Facet));
        AggregatedFacet aggregatedFacet = (AggregatedFacet)customClassifiers.get(0);
        Assert.assertNotNull((String)"The AggregatedFacet must proxy a Facet", (Object)aggregatedFacet.getFacet());
        Facet facet = aggregatedFacet.getFacet();
        Assert.assertTrue((String)"The AggregatedFacet must proxy an EClassCustomization", (boolean)(facet instanceof EClassCustomization));
        EList facetOperations = aggregatedFacet.getFacetOperations();
        Assert.assertEquals((String)"The AggregatedFacet (EClassCustomization) must contain one operation", (long)1L, (long)facetOperations.size());
        FacetOperation facetOperation = (FacetOperation)facetOperations.get(0);
        Assert.assertTrue((String)"The FacetOperation should be an AggregatedOperation", (boolean)(facetOperation instanceof AggregatedOperation));
        Assert.assertEquals((String)"The FacetOperation should customize the label", (Object)"label", (Object)facetOperation.getName());
    }

    @Test
    public void testResolveAggregates() throws Exception {
        IResolverManager resolver = IResolverManager.DEFAULT;
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl());
        Aggregate aggregate = (Aggregate)FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)"Bug372626_Aggregates_aggregate");
        Assert.assertNotNull((String)"The FacetSet must be resolved", (Object)resolver.resolve(aggregate.getFacetSets().get(0), FacetSet.class));
        Assert.assertNotNull((String)"The Facet must be resolved", (Object)resolver.resolve(((FacetSet)aggregate.getFacetSets().get(0)).getEClassifiers().get(0), Facet.class));
        Assert.assertNotNull((String)"The Customization must be resolved", (Object)resolver.resolve(aggregate.getFacetSets().get(1), Customization.class));
        Assert.assertNotNull((String)"The EClassCustomization must be resolved", (Object)resolver.resolve(((FacetSet)aggregate.getFacetSets().get(1)).getEClassifiers().get(0), EClassCustomization.class));
        Assert.assertNotNull((String)"The FacetOperation must be resolved", (Object)resolver.resolve(((Facet)((FacetSet)aggregate.getFacetSets().get(1)).getEClassifiers().get(0)).getFacetOperations().get(0), FacetOperation.class));
    }
}

