/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.tests.internal.Activator;
import org.junit.Assert;
import org.junit.Test;

public class IsOneOfQueryTest {
    private static final String TEST_FILE = "org.eclipse.emf.facet.efacet.tests.isoneofquery.efacet";

    @Test
    public void test() throws FacetManagerException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        URI uri = URI.createPlatformPluginURI((String)bundleName, (boolean)true);
        uri = uri.appendSegments("resources/v0_2".split("/"));
        uri = uri.appendSegment(TEST_FILE);
        Resource resource = resourceSet.getResource(uri, true);
        EObject eObject = (EObject)resource.getContents().get(0);
        Assert.assertTrue((String)"The resource's root must be a FacetSet.", (boolean)(eObject instanceof FacetSet));
        FacetSet facetSet = (FacetSet)eObject;
        Assert.assertEquals((String)"The facet set should contains one facet", (long)1L, (long)FacetUtils.getFacets((FacetSet)facetSet).size());
        Facet facet = (Facet)FacetUtils.getFacets((FacetSet)facetSet).get(0);
        IFacetManager manager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
        Assert.assertTrue((String)"The class 'EAnnotation' must conform to the test facet.", (boolean)manager.isConforming((EObject)EcorePackage.eINSTANCE.getEAnnotation(), facet));
        Assert.assertFalse((String)"The class 'EAttribute' must not conform to the test facet.", (boolean)manager.isConforming((EObject)EcorePackage.eINSTANCE.getEAttribute(), facet));
    }
}

