/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.reorder.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiColumnReorderCommand
implements ILayerCommand {
    private List<ColumnPositionCoordinate> fromColumnPositionCoordinates;
    private ColumnPositionCoordinate toColumnPositionCoordinate;

    public MultiColumnReorderCommand(ILayer layer, List<Integer> fromColumnPositions, int toColumnPositions) {
        this.fromColumnPositionCoordinates = new ArrayList<ColumnPositionCoordinate>();
        for (Integer fromColumnPosition : fromColumnPositions) {
            this.fromColumnPositionCoordinates.add(new ColumnPositionCoordinate(layer, fromColumnPosition));
        }
        this.toColumnPositionCoordinate = new ColumnPositionCoordinate(layer, toColumnPositions);
    }

    protected MultiColumnReorderCommand(MultiColumnReorderCommand command) {
        this.fromColumnPositionCoordinates = new ArrayList<ColumnPositionCoordinate>(command.fromColumnPositionCoordinates);
        this.toColumnPositionCoordinate = command.toColumnPositionCoordinate;
    }

    public List<Integer> getFromColumnPositions() {
        ArrayList<Integer> fromColumnPositions = new ArrayList<Integer>();
        for (ColumnPositionCoordinate fromColumnPositionCoordinate : this.fromColumnPositionCoordinates) {
            fromColumnPositions.add(fromColumnPositionCoordinate.getColumnPosition());
        }
        return fromColumnPositions;
    }

    public int getToColumnPosition() {
        return this.toColumnPositionCoordinate.getColumnPosition();
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        ArrayList<ColumnPositionCoordinate> convertedFromColumnPositionCoordinates = new ArrayList<ColumnPositionCoordinate>();
        for (ColumnPositionCoordinate fromColumnPositionCoordinate : this.fromColumnPositionCoordinates) {
            ColumnPositionCoordinate convertedFromColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(fromColumnPositionCoordinate, targetLayer);
            if (convertedFromColumnPositionCoordinate == null) continue;
            convertedFromColumnPositionCoordinates.add(convertedFromColumnPositionCoordinate);
        }
        this.fromColumnPositionCoordinates = convertedFromColumnPositionCoordinates;
        this.toColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(this.toColumnPositionCoordinate, targetLayer);
        return this.fromColumnPositionCoordinates.size() > 0 && this.toColumnPositionCoordinate != null;
    }

    @Override
    public MultiColumnReorderCommand cloneCommand() {
        return new MultiColumnReorderCommand(this);
    }
}

