/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.ui.tests.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPackageRegistryTest {
    private static final int TIMEOUT = 30000;

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestUtils.closeWelcomePage();
        TestUtils.closeAllEditors();
        EPackageRegistryTest.disableEMFFacetCapability();
    }

    public static void disableEMFFacetCapability() throws Exception {
        final IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = activitySupport.getActivityManager();
        final HashSet<String> newActivities = new HashSet<String>(activityManager.getEnabledActivityIds());
        newActivities.add("org.eclipse.emf.facet.capabilities.activity");
        newActivities.add("org.eclipse.emf.facet.infra.activities");
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                activitySupport.setEnabledActivityIds((Set)newActivities);
            }
        });
    }

    @Test(timeout=30000L)
    public void canOpenERegistryView() throws Exception {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getWorkbenchWindows()[0];
        final IWorkbenchPage page = window.getPages()[0];
        final Exception[] exception = new Exception[1];
        final IViewPart[] part = new IViewPart[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    part[0] = page.showView("org.eclipse.emf.facet.infra.common.ui.views.packageRegistry");
                }
                catch (Exception e) {
                    exception[0] = e;
                }
            }
        };
        Display.getDefault().syncExec(runnable);
        if (exception[0] != null) {
            throw exception[0];
        }
        Assert.assertNotNull((String)"A view EPackage Registryshould be opened", (Object)part[0]);
        Assert.assertEquals((String)"The returned part should have the expected title.", (Object)"EPackage Registry", (Object)part[0].getTitle());
    }
}

