/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.internal.catalog.v2;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.catalog.metamodel.internal.v1_1.catalog.CatalogFactory;
import org.eclipse.emf.facet.util.emf.catalog.metamodel.internal.v1_1.catalog.InstallAndWokspaceCatalog;
import org.eclipse.emf.facet.util.emf.core.catalog.ICatalogManager;
import org.eclipse.emf.facet.util.emf.core.catalog.ICatalogManagerConfiguration;
import org.eclipse.emf.facet.util.emf.core.internal.Activator;
import org.eclipse.emf.facet.util.emf.core.internal.catalog.v2.CatalogListenerFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CatalogManager
implements ICatalogManager,
Adapter {
    private static final String MODEL_DECL_EXT_PT = "org.eclipse.emf.facet.util.emf.core.modeldeclaration";
    private static final String FILE = "file";
    private final Map<Resource, Bundle> resourceToBundle = new HashMap<Resource, Bundle>();
    private final ICatalogManagerConfiguration catalogMgrconfig;
    private InstallAndWokspaceCatalog catalog;
    private final ResourceSet resourceSet;
    private final String catalogId;

    public CatalogManager(ICatalogManagerConfiguration catalogMgrconfig, ResourceSet resourceSet, String catalogId) {
        Resource resource;
        URI uri;
        String uriStr;
        this.resourceSet = resourceSet;
        this.catalogMgrconfig = catalogMgrconfig;
        this.catalogId = catalogId;
        if (catalogId == null) {
            uriStr = String.format("tmp://%s", this.getClass().getName());
            uri = URI.createURI((String)uriStr);
        } else {
            uriStr = String.format("platform:/meta/%s/%s.xmi", Activator.getDefault().getBundle().getSymbolicName(), catalogId);
            uri = URI.createURI((String)uriStr);
        }
        if (catalogId == null) {
            resource = this.resourceSet.createResource(uri);
        } else {
            try {
                resource = this.resourceSet.getResource(uri, true);
            }
            catch (WrappedException e) {
                if (!(e.getCause() instanceof FileNotFoundException)) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
                resource = this.resourceSet.createResource(uri);
            }
        }
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof InstallAndWokspaceCatalog) {
            this.catalog = (InstallAndWokspaceCatalog)resource.getContents().get(0);
        } else {
            this.catalog = CatalogFactory.eINSTANCE.createInstallAndWokspaceCatalog();
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)resource);
            if (editingDomain == null) {
                resource.getContents().add((Object)this.catalog);
            } else {
                AddCommand command = new AddCommand((EditingDomain)editingDomain, resource.getContents(), (Object)this.catalog);
                editingDomain.getCommandStack().execute((Command)command);
            }
        }
        this.initRegisteredEntries();
        CatalogListenerFactory.adaptResource((Notifier)this.catalog, resource);
    }

    private void initRegisteredEntries() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint modelDeclExtPoint = registry.getExtensionPoint(MODEL_DECL_EXT_PT);
        if (modelDeclExtPoint != null) {
            IExtension[] iExtensionArray = modelDeclExtPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElt = iConfigurationElementArray[n4];
                    String filePath = configElt.getAttribute(FILE);
                    if (filePath != null) {
                        String pluginName = ext.getNamespaceIdentifier();
                        Bundle bundle = Platform.getBundle((String)pluginName);
                        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(pluginName) + "/" + filePath), (boolean)false);
                        try {
                            Resource resource = this.resourceSet.getResource(uri, true);
                            this.resourceToBundle.put(resource, bundle);
                            for (EObject root : resource.getContents()) {
                                this.onInstalledModelFound(root);
                            }
                        }
                        catch (Exception e) {
                            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void onInstalledModelFound(EObject root) {
        if (this.catalogMgrconfig.canBeManaged(root) && this.catalogMgrconfig.isValid(root)) {
            this.catalog.getInstalledEntries().add((Object)root);
        }
    }

    @Override
    public <T> List<T> getEntries(Class<T> expectedClass) {
        ArrayList<T> result = new ArrayList<T>();
        List<T> filteredEntries = this.getInstalledEntries(expectedClass);
        result.addAll(filteredEntries);
        List<T> wsEntriesFiltered = this.getWsEntries(expectedClass);
        result.addAll(wsEntriesFiltered);
        return result;
    }

    @Override
    public <T> List<T> getWsEntries(Class<T> expectedClass) {
        return CatalogManager.getEntriesFilter(expectedClass, (List<EObject>)this.catalog.getWorkspaceEntries());
    }

    @Override
    public <T> List<T> getInstalledEntries(Class<T> expectedClass) {
        List<T> wsEntriesFiltered = CatalogManager.getEntriesFilter(expectedClass, (List<EObject>)this.catalog.getInstalledEntries());
        return wsEntriesFiltered;
    }

    private static <T> List<T> getEntriesFilter(Class<T> expectedClass, List<EObject> entries) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObject : entries) {
            if (!expectedClass.isInstance(eObject)) continue;
            EObject tObject = eObject;
            result.add(tObject);
        }
        return result;
    }

    @Override
    public boolean addWsEntry(EObject entry) {
        boolean result = false;
        if (this.catalogMgrconfig.canBeManaged(entry) && this.catalogMgrconfig.isValid(entry)) {
            this.catalog.getWorkspaceEntries().add((Object)entry);
            result = true;
        }
        return result;
    }

    @Override
    public void removeWsEntry(EObject entry) {
        this.catalog.getWorkspaceEntries().remove((Object)entry);
    }

    @Override
    public void removeAllWsEntries(IProject project) {
        ArrayList<EObject> toBeRemoved = new ArrayList<EObject>();
        List<EObject> wsEntries = this.getWsEntries(EObject.class);
        for (EObject registered : wsEntries) {
            Resource eResource = registered.eResource();
            if (eResource == null || registered.eIsProxy()) {
                toBeRemoved.add(registered);
                continue;
            }
            URI uri = eResource.getURI();
            String uriStr = uri.toString();
            if (!uriStr.startsWith("platform:/resource/" + project.getName())) continue;
            toBeRemoved.add(registered);
        }
        this.catalog.getWorkspaceEntries().removeAll(toBeRemoved);
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public void notifyChanged(Notification notification) {
    }

    public Notifier getTarget() {
        return this.resourceSet;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type == ICatalogManager.class;
    }
}

