/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EAttributeTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeElement;
import org.eclipse.emf.facet.custom.ui.internal.Activator;
import org.eclipse.emf.facet.custom.ui.internal.exception.CustomizedContentProviderRuntimeException;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.osgi.util.NLS;

public class TreeElementAdapter
implements Adapter {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private final EObjectTreeElement treeElement;
    private Notifier target;

    public TreeElementAdapter(EObjectTreeElement treeElement) {
        this.treeElement = treeElement;
    }

    public void notifyChanged(Notification notification) {
        DebugUtils.debug((boolean)DEBUG, (String)("Modified element=" + this.treeElement.getEObject()));
        DebugUtils.debug((boolean)DEBUG, (String)("Notification feature=" + notification.getFeature()));
        for (TreeElement subElement : this.treeElement.getChildren()) {
            EStructuralFeature feature = TreeElementAdapter.getSF(subElement);
            if (!feature.equals(notification.getFeature())) continue;
            subElement.getChildren().clear();
            DebugUtils.debug((boolean)DEBUG, (String)NLS.bind((String)"Cleanning= {0}::{1}", (Object)feature.getContainerClass().getName(), (Object)feature.getName()));
        }
    }

    private static EStructuralFeature getSF(TreeElement structFeatuteTE) {
        EAttribute result;
        if (structFeatuteTE instanceof EAttributeTreeElement) {
            EAttributeTreeElement eAttributeTE = (EAttributeTreeElement)structFeatuteTE;
            result = eAttributeTE.getEAttribute();
        } else if (structFeatuteTE instanceof EReferenceTreeElement) {
            EReferenceTreeElement eReferenceTE = (EReferenceTreeElement)structFeatuteTE;
            result = eReferenceTE.getEReference();
        } else {
            throw new CustomizedContentProviderRuntimeException("Illegal agrument: " + structFeatuteTE);
        }
        return result;
    }

    public Notifier getTarget() {
        return this.target;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget != null) {
            this.target = newTarget;
        }
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public EObjectTreeElement getTreeElement() {
        return this.treeElement;
    }
}

