/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.tests.internal.Activator;
import org.eclipse.emf.facet.efacet.tests.internal.v0_2.AbstractFacetActionTests;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class ResourceFacetActionTests
extends AbstractFacetActionTests {
    IProject testProject;

    public ResourceFacetActionTests() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        this.testProject = workspace.getRoot().getProject(this.getClass().getName());
        this.testProject.create((IProgressMonitor)new NullProgressMonitor());
        this.testProject.open((IProgressMonitor)new NullProgressMonitor());
        FileUtils.copyFileFromBundle((String)"/resources/v0_2/my.library", (IProject)this.testProject, (String)"/my.library", (Bundle)Activator.getDefault().getBundle());
    }

    private String getResourcePrefix() {
        return "platform:/resource/" + this.testProject.getName();
    }

    private static String getPluginPrefix() {
        return "platform:/plugin/" + Activator.getDefault().getBundle().getSymbolicName();
    }

    protected URI getSerialisationModelUri() {
        return URI.createURI((String)(String.valueOf(this.getResourcePrefix()) + '/' + "my.serialization"));
    }

    protected URI getFacetSetUri() {
        return URI.createURI((String)(String.valueOf(ResourceFacetActionTests.getPluginPrefix()) + '/' + "resources/v0_2" + '/' + "my.efacet2"));
    }

    protected URI getLibraryUri() {
        return URI.createURI((String)(String.valueOf(this.getResourcePrefix()) + '/' + "my.library"));
    }

    @Test(expected=FacetManagerException.class)
    public void testSetWithWrongExtendedMetaclass() throws Exception {
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set(EcoreFactory.eINSTANCE.createEObject(), (EStructuralFeature)this.facet1Attribute, (Object)AbstractFacetActionTests.REVISION_1, null);
    }

    @Test(expected=FacetManagerException.class)
    public void testGetWithWrongExtendedMetaclass() throws Exception {
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.getOrInvoke(EcoreFactory.eINSTANCE.createEObject(), (ETypedElement)this.facet1Attribute, null);
    }

    @Test(expected=FacetManagerException.class)
    public void testSetWithFalseConformanceQuery() throws Exception {
        IFacetManager facetManager2 = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager2.set((EObject)this.library, (EStructuralFeature)this.facet1Attribute, (Object)0, null);
    }

    @Test(expected=FacetManagerException.class)
    public void testGetWithFalseConformanceQuery() throws Exception {
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.facet1Attribute, Integer.class);
    }

    @Test
    public void testSetGetWithTrueConformanceQuery() throws Exception {
        Assert.assertEquals((long)0L, (long)this.serializationResource.getContents().size());
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set((EObject)this.library, (EStructuralFeature)this.facet2Attribute, (Object)AbstractFacetActionTests.REVISION_1, null);
        Assert.assertEquals((Object)AbstractFacetActionTests.REVISION_1, (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.facet2Attribute, Integer.class));
        this.assertReferenceInstanceListSize(0, 1);
    }

    @Test
    public void testConformanceWithFalseConformanceQuery() throws Exception {
        Assert.assertEquals((long)0L, (long)this.serializationResource.getContents().size());
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        Assert.assertFalse((boolean)facetManager.isConforming((EObject)this.library, this.facet1));
    }

    @Test
    public void testConformanceWithTrueConformanceQuery() throws Exception {
        Assert.assertEquals((long)0L, (long)this.serializationResource.getContents().size());
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        Assert.assertTrue((boolean)facetManager.isConforming((EObject)this.library, this.facet2));
    }

    @Test
    public void testConformanceNoConformanceQuery() throws Exception {
        Assert.assertEquals((long)0L, (long)this.serializationResource.getContents().size());
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        Assert.assertTrue((boolean)facetManager.isConforming((EObject)this.library, this.facetNoConformanceTypedElement));
    }
}

