/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2.uithread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Book;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Library;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Writer;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.tests.internal.Activator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotDerivedSFTest {
    private static final String BOOK1 = "book1";
    private static final String BOOK2 = "book2";
    private static final String BOOK3 = "book3";
    private static final String WRITER1 = "writer1";
    private static final String WRITER2 = "writer2";
    private static final String NOTHING = "nothing";
    private static final String CLASS_NAME = NotDerivedSFTest.class.getSimpleName();
    private static final String BUNDLE_NAME = Activator.getDefault().getBundle().getSymbolicName();
    private static final String WRITER_EXT = "WriterExt";
    private static final String PREFACED = "prefaced";
    private static final String PREFACE = "preface";
    private static final String BOOK_EXT = "BookExt";
    private static final String ONE_TO_ONE = "OToO";
    private static final String MANY_TO_MANY = "MToM";
    private static final String ONE_TO_MANY = "OToM";
    private static final String MANY_TO_ONE = "MToO";
    private Library lib;
    private IFacetManager facetMgr;
    private FacetSet extLibFS;
    private ResourceSet resourceSet;

    @Before
    public void before() {
        this.resourceSet = new ResourceSetImpl();
        Resource libResource = this.resourceSet.getResource(NotDerivedSFTest.getLiraryUri(), true);
        this.lib = (Library)libResource.getContents().get(0);
    }

    private void initWithSerialize(Resource serResource) {
        this.facetMgr = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManagerWithSerializationResource(serResource);
        Resource extLibResource = this.resourceSet.getResource(NotDerivedSFTest.getFSUri(), true);
        this.extLibFS = (FacetSet)extLibResource.getContents().get(0);
        this.facetMgr.getManagedFacetSets().add(this.extLibFS);
    }

    private void initWithoutSerialize() {
        this.facetMgr = IFacetManagerFactory.DEFAULT.getOrCreateDefaultFacetManager(this.resourceSet);
        Resource extLibResource = this.resourceSet.getResource(NotDerivedSFTest.getFSUri(), true);
        this.extLibFS = (FacetSet)extLibResource.getContents().get(0);
        this.facetMgr.getManagedFacetSets().add(this.extLibFS);
    }

    @Test
    public void oneToOneSerialize() throws FacetManagerException {
        URI serUri = NotDerivedSFTest.getSerializationResourceUri(ONE_TO_ONE);
        Resource serResource = this.resourceSet.createResource(serUri);
        this.initWithSerialize(serResource);
        FacetReference prefaced = this.getFacetRef(ONE_TO_ONE, BOOK_EXT, PREFACED);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Book book1 = (Book)this.lib.getBooks().get(0);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)prefaced, (Object)writer1, null);
        this.oneToOneAssert(writer1, book1);
        this.facetMgr.saveStructuralFeatureInstanceModel();
    }

    @Test
    public void oneToOneDeserialize() throws FacetManagerException {
        URI serUri = NotDerivedSFTest.getSerializationResourceUri(ONE_TO_ONE);
        Resource serResource = this.resourceSet.getResource(serUri, true);
        this.initWithSerialize(serResource);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Book book1 = (Book)this.lib.getBooks().get(0);
        this.oneToOneAssert(writer1, book1);
    }

    private void oneToOneAssert(Writer writer1, Book book1) throws FacetManagerException {
        FacetReference prefaced = this.getFacetRef(ONE_TO_ONE, BOOK_EXT, PREFACED);
        Writer book1writer = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), (Object)writer1, (Object)book1writer);
        FacetReference preface = this.getFacetRef(ONE_TO_ONE, WRITER_EXT, PREFACE);
        Book prefacedBook = (Book)this.facetMgr.getOrInvoke((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK1), (Object)book1, (Object)prefacedBook);
    }

    @Test
    public void oneToOneFOpposite() throws FacetManagerException {
        this.initWithoutSerialize();
        FacetReference prefaced = this.getFacetRef(ONE_TO_ONE, BOOK_EXT, PREFACED);
        FacetReference preface = this.getFacetRef(ONE_TO_ONE, WRITER_EXT, PREFACE);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Writer writer2 = (Writer)this.lib.getWriters().get(1);
        Book book1 = (Book)this.lib.getBooks().get(0);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)prefaced, (Object)writer1, null);
        Writer writer1book1 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), (Object)writer1, (Object)writer1book1);
        Book book1writer1 = (Book)this.facetMgr.getOrInvoke((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK1), (Object)book1, (Object)book1writer1);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)prefaced, (Object)writer2, null);
        Writer writer2book1 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER2), (Object)writer2, (Object)writer2book1);
        Book book1writer2 = (Book)this.facetMgr.getOrInvoke((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, BOOK1), (Object)book1, (Object)book1writer2);
        Book nothing = (Book)this.facetMgr.getOrInvoke((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertNull((String)NotDerivedSFTest.msg(WRITER1, NOTHING), (Object)nothing);
    }

    @Test
    public void manyToManySerialize() throws FacetManagerException {
        URI serUri = NotDerivedSFTest.getSerializationResourceUri(MANY_TO_MANY);
        Resource serResource = this.resourceSet.createResource(serUri);
        this.initWithSerialize(serResource);
        FacetReference mTmPrefaced = this.getFacetRef(MANY_TO_MANY, BOOK_EXT, PREFACED);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Writer writer2 = (Writer)this.lib.getWriters().get(1);
        Book book1 = (Book)this.lib.getBooks().get(0);
        Book book2 = (Book)this.lib.getBooks().get(1);
        Book book3 = (Book)this.lib.getBooks().get(2);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)mTmPrefaced, Arrays.asList(writer1), null);
        this.facetMgr.set((EObject)book2, (EStructuralFeature)mTmPrefaced, Arrays.asList(writer2), null);
        this.facetMgr.set((EObject)book3, (EStructuralFeature)mTmPrefaced, Arrays.asList(writer1, writer2), null);
        this.manyToManyAssert((List<Writer>)this.lib.getWriters(), (List<Book>)this.lib.getBooks());
        this.facetMgr.saveStructuralFeatureInstanceModel();
    }

    @Test
    public void manyToManyDeserialize() throws FacetManagerException {
        URI serUri = NotDerivedSFTest.getSerializationResourceUri(MANY_TO_MANY);
        Resource serResource = this.resourceSet.getResource(serUri, true);
        this.initWithSerialize(serResource);
        this.manyToManyAssert((List<Writer>)this.lib.getWriters(), (List<Book>)this.lib.getBooks());
    }

    private void manyToManyAssert(List<Writer> writers, List<Book> books) throws FacetManagerException {
        Writer writer1 = writers.get(0);
        Writer writer2 = writers.get(1);
        Book book1 = books.get(0);
        Book book2 = books.get(1);
        Book book3 = books.get(2);
        FacetReference prefaced = this.getFacetRef(MANY_TO_MANY, BOOK_EXT, PREFACED);
        List book1writer = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), Arrays.asList(writer1), (Object)book1writer);
        List book2writer = this.facetMgr.getOrInvokeMultiValued((EObject)book2, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK2, WRITER2), Arrays.asList(writer2), (Object)book2writer);
        List book3writer = this.facetMgr.getOrInvokeMultiValued((EObject)book3, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK3, "writer1 and writer2"), Arrays.asList(writer1, writer2), (Object)book3writer);
        FacetReference preface = this.getFacetRef(MANY_TO_MANY, WRITER_EXT, PREFACE);
        List writer1Books = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, "book1 and book3"), Arrays.asList(book1, book3), (Object)writer1Books);
        List writer2Books = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, "book2 and book3"), Arrays.asList(book2, book3), (Object)writer2Books);
    }

    @Test
    public void manyToManyFOpposite() throws FacetManagerException {
        this.initWithoutSerialize();
        FacetReference prefaced = this.getFacetRef(MANY_TO_MANY, BOOK_EXT, PREFACED);
        FacetReference preface = this.getFacetRef(MANY_TO_MANY, WRITER_EXT, PREFACE);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Writer writer2 = (Writer)this.lib.getWriters().get(1);
        Book book1 = (Book)this.lib.getBooks().get(0);
        Book book2 = (Book)this.lib.getBooks().get(1);
        List<Writer> writers1 = Arrays.asList(writer1);
        List<Book> books1 = Arrays.asList(book1);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)prefaced, writers1, null);
        List writer1book1 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), writers1, (Object)writer1book1);
        List book1writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK1), books1, (Object)book1writer1);
        List<Writer> writers2 = Arrays.asList(writer2);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)prefaced, writers2, null);
        List writer2book1 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER2), writers2, (Object)writer2book1);
        List book1writer2 = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, BOOK1), books1, (Object)book1writer2);
        List noBooks = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, NOTHING), (Object)Collections.EMPTY_LIST, (Object)noBooks);
        List<Writer> writers12 = Arrays.asList(writer1, writer2);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)prefaced, writers12, null);
        List writer12book1 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, "writer1 and writer 2"), writers12, (Object)writer12book1);
        List books1writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK1), books1, (Object)books1writer1);
        List books2writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, BOOK1), books1, (Object)books2writer1);
        this.facetMgr.set((EObject)book2, (EStructuralFeature)prefaced, writers2, null);
        books1writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK1), books1, (Object)books1writer1);
        List books12writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, "book1 and book2"), Arrays.asList(book1, book2), (Object)books12writer1);
        this.facetMgr.set((EObject)book1, (EStructuralFeature)prefaced, (Object)Collections.EMPTY_LIST, null);
        List noWriters = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg("bookl", NOTHING), (Object)Collections.EMPTY_LIST, (Object)noWriters);
        noBooks = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, NOTHING), (Object)Collections.EMPTY_LIST, (Object)noBooks);
        List books2writer2 = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, BOOK2), Arrays.asList(book2), (Object)books2writer2);
        this.facetMgr.set((EObject)book2, (EStructuralFeature)prefaced, (Object)Collections.EMPTY_LIST, null);
        noWriters = this.facetMgr.getOrInvokeMultiValued((EObject)book2, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK2, NOTHING), (Object)Collections.EMPTY_LIST, (Object)noWriters);
        noBooks = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, NOTHING), (Object)Collections.EMPTY_LIST, (Object)noBooks);
    }

    @Test
    public void manyToOneSerialize() throws FacetManagerException {
        URI serUri = NotDerivedSFTest.getSerializationResourceUri(MANY_TO_ONE);
        Resource serResource = this.resourceSet.createResource(serUri);
        this.initWithSerialize(serResource);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Writer writer2 = (Writer)this.lib.getWriters().get(1);
        Book book1 = (Book)this.lib.getBooks().get(0);
        FacetReference preface = this.getFacetRef(MANY_TO_ONE, WRITER_EXT, PREFACE);
        this.facetMgr.set((EObject)writer1, (EStructuralFeature)preface, (Object)book1, null);
        this.facetMgr.set((EObject)writer2, (EStructuralFeature)preface, (Object)book1, null);
        this.manyToOneAssert(writer1, writer2, book1);
        this.facetMgr.saveStructuralFeatureInstanceModel();
    }

    @Test
    public void manyToOneDeserialize() throws FacetManagerException {
        URI serUri = NotDerivedSFTest.getSerializationResourceUri(MANY_TO_ONE);
        Resource serResource = this.resourceSet.getResource(serUri, true);
        this.initWithSerialize(serResource);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Writer writer2 = (Writer)this.lib.getWriters().get(1);
        Book book1 = (Book)this.lib.getBooks().get(0);
        this.manyToOneAssert(writer1, writer2, book1);
    }

    private void manyToOneAssert(Writer writer1, Writer writer2, Book book1) throws FacetManagerException {
        FacetReference preface = this.getFacetRef(MANY_TO_ONE, WRITER_EXT, PREFACE);
        Book book1writer1 = (Book)this.facetMgr.getOrInvoke((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK1), (Object)book1, (Object)book1writer1);
        Book book1writer2 = (Book)this.facetMgr.getOrInvoke((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, BOOK1), (Object)book1, (Object)book1writer2);
        FacetReference prefaced = this.getFacetRef(MANY_TO_ONE, BOOK_EXT, PREFACED);
        List writers1and2 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, "writer1 and writer 2"), Arrays.asList(writer1, writer2), (Object)writers1and2);
    }

    @Test
    public void manyToOneFOpposite() throws FacetManagerException {
        this.initWithoutSerialize();
        FacetReference preface = this.getFacetRef(MANY_TO_ONE, WRITER_EXT, PREFACE);
        FacetReference prefaced = this.getFacetRef(MANY_TO_ONE, BOOK_EXT, PREFACED);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Writer writer2 = (Writer)this.lib.getWriters().get(1);
        Book book1 = (Book)this.lib.getBooks().get(0);
        Book book2 = (Book)this.lib.getBooks().get(1);
        this.facetMgr.set((EObject)writer1, (EStructuralFeature)preface, (Object)book1, null);
        Book book1writer1 = (Book)this.facetMgr.getOrInvoke((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK1), (Object)book1, (Object)book1writer1);
        List writers1 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), Arrays.asList(writer1), (Object)writers1);
        this.facetMgr.set((EObject)writer2, (EStructuralFeature)preface, (Object)book1, null);
        Book book1writer2 = (Book)this.facetMgr.getOrInvoke((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, BOOK1), (Object)book1, (Object)book1writer2);
        List writers1and2 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, "writer1 and writer 2"), Arrays.asList(writer1, writer2), (Object)writers1and2);
        this.facetMgr.set((EObject)writer1, (EStructuralFeature)preface, (Object)book2, null);
        Book book2writer1 = (Book)this.facetMgr.getOrInvoke((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK2), (Object)book2, (Object)book2writer1);
        List writers2 = this.facetMgr.getOrInvokeMultiValued((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER2), Arrays.asList(writer2), (Object)writers2);
        writers1 = this.facetMgr.getOrInvokeMultiValued((EObject)book2, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), Arrays.asList(writer1), (Object)writers1);
    }

    @Test
    public void oneToManySerialize() throws FacetManagerException {
        URI serUri = NotDerivedSFTest.getSerializationResourceUri(ONE_TO_MANY);
        Resource serResource = this.resourceSet.createResource(serUri);
        this.initWithSerialize(serResource);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Book book1 = (Book)this.lib.getBooks().get(0);
        Book book2 = (Book)this.lib.getBooks().get(1);
        FacetReference preface = this.getFacetRef(ONE_TO_MANY, WRITER_EXT, PREFACE);
        this.facetMgr.set((EObject)writer1, (EStructuralFeature)preface, Arrays.asList(book1, book2), null);
        this.oneToManyAssert(writer1, book1, book2);
        this.facetMgr.saveStructuralFeatureInstanceModel();
    }

    @Test
    public void oneToManyDeserialize() throws FacetManagerException {
        URI serUri = NotDerivedSFTest.getSerializationResourceUri(ONE_TO_MANY);
        Resource serResource = this.resourceSet.getResource(serUri, true);
        this.initWithSerialize(serResource);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Book book1 = (Book)this.lib.getBooks().get(0);
        Book book2 = (Book)this.lib.getBooks().get(1);
        this.oneToManyAssert(writer1, book1, book2);
    }

    private void oneToManyAssert(Writer writer1, Book book1, Book book2) throws FacetManagerException {
        FacetReference preface = this.getFacetRef(ONE_TO_MANY, WRITER_EXT, PREFACE);
        List book12writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)"writer1 must be linked to book1 and book2", Arrays.asList(book1, book2), (Object)book12writer1);
        FacetReference prefaced = this.getFacetRef(ONE_TO_MANY, BOOK_EXT, PREFACED);
        Writer writer1Book1 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), (Object)writer1, (Object)writer1Book1);
        Writer writer1Book2 = (Writer)this.facetMgr.getOrInvoke((EObject)book2, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK2, WRITER1), (Object)writer1, (Object)writer1Book2);
    }

    @Test
    public void oneToManyFOpposite() throws FacetManagerException {
        this.initWithoutSerialize();
        FacetReference preface = this.getFacetRef(ONE_TO_MANY, WRITER_EXT, PREFACE);
        FacetReference prefaced = this.getFacetRef(ONE_TO_MANY, BOOK_EXT, PREFACED);
        Writer writer1 = (Writer)this.lib.getWriters().get(0);
        Writer writer2 = (Writer)this.lib.getWriters().get(1);
        Book book1 = (Book)this.lib.getBooks().get(0);
        Book book2 = (Book)this.lib.getBooks().get(1);
        this.facetMgr.set((EObject)writer1, (EStructuralFeature)preface, Arrays.asList(book1, book2), null);
        List books12writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, "book1 and book2"), Arrays.asList(book1, book2), (Object)books12writer1);
        List nothingWriter2 = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)"writer2 must be linked to nothing", (Object)Collections.EMPTY_LIST, (Object)nothingWriter2);
        Writer writer1book1 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), (Object)writer1, (Object)writer1book1);
        Writer writer1book2 = (Writer)this.facetMgr.getOrInvoke((EObject)book2, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK2, WRITER1), (Object)writer1, (Object)writer1book2);
        this.facetMgr.set((EObject)writer2, (EStructuralFeature)preface, Arrays.asList(book2), null);
        List books2Writer2 = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, BOOK2), Arrays.asList(book2), (Object)books2Writer2);
        List books1Writer1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, BOOK1), Arrays.asList(book1), (Object)books1Writer1);
        writer1book1 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER1), (Object)writer1, (Object)writer1book1);
        Writer writer2book2 = (Writer)this.facetMgr.getOrInvoke((EObject)book2, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK2, WRITER2), (Object)writer2, (Object)writer2book2);
        this.facetMgr.set((EObject)writer2, (EStructuralFeature)preface, Arrays.asList(book1, book2), null);
        List books12writer2 = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, "book1 and book2"), Arrays.asList(book1, book2), (Object)books12writer2);
        List nothingWriter1 = this.facetMgr.getOrInvokeMultiValued((EObject)writer1, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER1, NOTHING), (Object)Collections.EMPTY_LIST, (Object)nothingWriter1);
        Writer writer2book1 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK1, WRITER2), (Object)writer2, (Object)writer2book1);
        writer2book2 = (Writer)this.facetMgr.getOrInvoke((EObject)book2, (ETypedElement)prefaced, Writer.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(BOOK2, WRITER2), (Object)writer2, (Object)writer2book2);
        this.facetMgr.set((EObject)writer2, (EStructuralFeature)preface, (Object)Collections.EMPTY_LIST, null);
        List nothingwriter2 = this.facetMgr.getOrInvokeMultiValued((EObject)writer2, (ETypedElement)preface, Book.class);
        Assert.assertEquals((String)NotDerivedSFTest.msg(WRITER2, NOTHING), (Object)Collections.EMPTY_LIST, (Object)nothingwriter2);
        Writer nothingBook1 = (Writer)this.facetMgr.getOrInvoke((EObject)book1, (ETypedElement)prefaced, Writer.class);
        Assert.assertNull((String)NotDerivedSFTest.msg(BOOK1, NOTHING), (Object)nothingBook1);
        Writer nothingBook2 = (Writer)this.facetMgr.getOrInvoke((EObject)book2, (ETypedElement)prefaced, Writer.class);
        Assert.assertNull((String)NotDerivedSFTest.msg(BOOK2, NOTHING), (Object)nothingBook2);
    }

    private FacetReference getFacetRef(String subFacetSetName, String facetName, String referenceName) {
        ArrayList<FacetSet> extLibSubFacetSet = new ArrayList<FacetSet>();
        for (EPackage ePackage : this.extLibFS.getESubpackages()) {
            if (!(ePackage instanceof FacetSet)) continue;
            FacetSet extLibSubFS = (FacetSet)ePackage;
            extLibSubFacetSet.add(extLibSubFS);
        }
        FacetSet subFacetSet = FacetUtils.getFacetSet(extLibSubFacetSet, (String)subFacetSetName);
        Facet facet = FacetUtils.getFacet((FacetSet)subFacetSet, (String)facetName);
        return (FacetReference)FacetUtils.getETypedElement((Facet)facet, (String)referenceName, FacetReference.class);
    }

    private static URI getSerializationResourceUri(String test) {
        String uriStr = String.format("platform:/meta/%s/%s/%s.xmi", BUNDLE_NAME, CLASS_NAME, test);
        return URI.createURI((String)uriStr);
    }

    private static URI getLiraryUri() {
        String uriStr = String.format("platform:/plugin/%s/%s/%s/My.library", BUNDLE_NAME, "resources/v0_2", CLASS_NAME);
        return URI.createURI((String)uriStr);
    }

    private static URI getFSUri() {
        String uriStr = String.format("platform:/plugin/%s/%s/%s/ExtendedLibrary.efacet", BUNDLE_NAME, "resources/v0_2", CLASS_NAME);
        return URI.createURI((String)uriStr);
    }

    private static String msg(String source, String target) {
        return String.format("%s must be linked to %s", source, target);
    }
}

