/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2.uithread;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug420093 {
    private static final String ONLY_ONE_INSTANCE = "Only one facetSet instance must be stored in the facet manager";
    private IFacetManager facetManager;

    @Before
    public void before() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
    }

    @Test
    public void add() {
        FacetSet facetSet = EFacetFactory.eINSTANCE.createFacetSet();
        this.facetManager.getManagedFacetSets().add(facetSet);
        this.facetManager.getManagedFacetSets().add(facetSet);
        Assert.assertTrue((String)ONLY_ONE_INSTANCE, (boolean)this.checkOnlyOneOccurence(facetSet));
    }

    @Test
    public void addAll() {
        FacetSet facetSet = EFacetFactory.eINSTANCE.createFacetSet();
        ArrayList<FacetSet> facetSetToAdd = new ArrayList<FacetSet>();
        facetSetToAdd.add(facetSet);
        facetSetToAdd.add(facetSet);
        this.facetManager.getManagedFacetSets().addAll(facetSetToAdd);
        Assert.assertTrue((String)ONLY_ONE_INSTANCE, (boolean)this.checkOnlyOneOccurence(facetSet));
    }

    @Test
    public void addIndex() {
        FacetSet facetSet1 = EFacetFactory.eINSTANCE.createFacetSet();
        FacetSet facetSet2 = EFacetFactory.eINSTANCE.createFacetSet();
        FacetSet facetSet3 = EFacetFactory.eINSTANCE.createFacetSet();
        this.facetManager.getManagedFacetSets().add(facetSet1);
        this.facetManager.getManagedFacetSets().add(facetSet2);
        this.facetManager.getManagedFacetSets().add(facetSet3);
        this.facetManager.getManagedFacetSets().add(1, facetSet1);
        Assert.assertTrue((String)ONLY_ONE_INSTANCE, (boolean)this.checkOnlyOneOccurence(facetSet1));
    }

    @Test
    public void addAllIndex() {
        FacetSet facetSet1 = EFacetFactory.eINSTANCE.createFacetSet();
        FacetSet facetSet2 = EFacetFactory.eINSTANCE.createFacetSet();
        FacetSet facetSet3 = EFacetFactory.eINSTANCE.createFacetSet();
        FacetSet facetSet4 = EFacetFactory.eINSTANCE.createFacetSet();
        FacetSet facetSet5 = EFacetFactory.eINSTANCE.createFacetSet();
        ArrayList<FacetSet> facetSetToAdd = new ArrayList<FacetSet>();
        facetSetToAdd.add(facetSet1);
        facetSetToAdd.add(facetSet2);
        facetSetToAdd.add(facetSet2);
        facetSetToAdd.add(facetSet3);
        facetSetToAdd.add(facetSet4);
        facetSetToAdd.add(facetSet5);
        Assert.assertTrue((String)ONLY_ONE_INSTANCE, (boolean)this.checkOnlyOneOccurence(facetSet2));
        this.facetManager.getManagedFacetSets().addAll(facetSetToAdd);
        ArrayList<FacetSet> facetSetToAdd2 = new ArrayList<FacetSet>();
        facetSetToAdd2.add(facetSet1);
        facetSetToAdd2.add(facetSet1);
        facetSetToAdd2.add(facetSet2);
        facetSetToAdd2.add(facetSet3);
        this.facetManager.getManagedFacetSets().addAll(1, facetSetToAdd2);
        Assert.assertTrue((String)ONLY_ONE_INSTANCE, (boolean)this.checkOnlyOneOccurence(facetSet1));
    }

    private boolean checkOnlyOneOccurence(FacetSet facetSet1) {
        List managedFacetSets = this.facetManager.getManagedFacetSets();
        return managedFacetSets.lastIndexOf(facetSet1) == managedFacetSets.indexOf(facetSet1);
    }
}

