/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.junit.Assert;
import org.junit.Test;

public class FacetOverrideTest {
    static final String REGULAR = "[Regular] ";
    static final String ABSTRACT = "[Abstract] ";

    @Test
    public void testOverride() throws FacetManagerException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IFacetManager manager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.efacet.tests/resources/org.eclipse.emf.facet.efacet.tests.internal.OverrideTest01.efacet2");
        Resource resource = resourceSet.getResource(uri, true);
        Assert.assertNotNull((Object)resource);
        EList contents = resource.getContents();
        Assert.assertEquals((long)contents.size(), (long)1L);
        EObject firstObject = (EObject)contents.get(0);
        Assert.assertTrue((boolean)(firstObject instanceof FacetSet));
        FacetSet facetSet1 = (FacetSet)firstObject;
        manager.getManagedFacetSets().add(0, facetSet1);
        EClassifier facetClassifier = facetSet1.getEClassifier("EClassExt");
        Assert.assertTrue((boolean)(facetClassifier instanceof Facet));
        Facet facet = (Facet)facetClassifier;
        facet.getFacetElements();
        FacetAttribute attr = (FacetAttribute)FacetUtils.getETypedElement((Facet)facet, (String)"label", FacetAttribute.class);
        EClass eObjectClass = EcorePackage.eINSTANCE.getEObject();
        Assert.assertFalse((boolean)eObjectClass.isAbstract());
        String label = (String)manager.getOrInvoke((EObject)eObjectClass, (ETypedElement)attr, String.class);
        Assert.assertEquals((Object)label, (Object)(REGULAR + eObjectClass.getName()));
        EClass eNamedElementClass = EcorePackage.eINSTANCE.getENamedElement();
        Assert.assertTrue((boolean)eNamedElementClass.isAbstract());
        String labelAbstract = (String)manager.getOrInvoke((EObject)eNamedElementClass, (ETypedElement)attr, String.class);
        Assert.assertEquals((Object)labelAbstract, (Object)(ABSTRACT + eNamedElementClass.getName()));
    }
}

